/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qVtA
 */

//  Simple Encoder for "---- -- ----"
//  
//  ---- -- ---- ("Linear" Brainf*ck interpreter)
//   by psyark
//   http://wonderfl.net/code/c35031bf80da29e99a20f1e1b991a99068cfba67
//  
//  [USAGE]
//  　Input Brainf*ck code in the upper text field,
//   and push the blue button.
//  　(All characters except "><+-[]." will be ignored.
//   "," is not supported originally.)
//  　A "linear code" will appear on the downer text field.
//  　Then copy it, fork psyark's ---- -- ---- from cited
//   URL, and paste it in a line sandwiched between arrows.
//  
//  e.g. "Hello, World!" in Brainf*ck
//  　+++++++++[>++++++++>+++++++++++>+++++<<<-]>.>++.+++++++..+++.>-.
//   ------------.<++++++++.--------.+++.------.--------.>+.
//   　from Wikipedia(ja)
//    http://ja.wikipedia.org/wiki/Hello_world%E3%83%97%E3%83%AD%E3%82%B0%E3%83%A9%E3%83%A0%E3%81%AE%E4%B8%80%E8%A6%A7#Brainfuck

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.geom.Matrix;
    
    public class SimpleEncoder extends Sprite
    {
        private var input:TextField;
        private var output:TextField;
        
        public function SimpleEncoder()
        {
            init().addEventListener(MouseEvent.CLICK, encode);
        }
        
        private function encode(e:MouseEvent):void
        {
            output.text = input.text.replace(/>/g, "\u30FC")
                                    .replace(/</g, "\uFF70")
                                    .replace(/\+/g, "\u1173")
                                    .replace(/-/g, "\u3161")
                                    .replace(/\[/g, "\u1428")
                                    .replace(/\]/g, "x")
                                    .replace(/\./g, "\u4E00")
                                    .replace(/(.)/g, "$1-")
                                    .replace(/x/g, "\u1428\u1428")
                                    .replace(/-$/, "");
        }
        
        private function init():Sprite
        {
            var fmt:TextFormat = new TextFormat();
            var mgn:Number = 10;
            
            input = new TextField();
            fmt.size = 16;
            input.defaultTextFormat = fmt;
            input.type = "input";
            input.restrict = "><+\\-[].";
            input.wordWrap = true;
            input.border = true;
            input.x = mgn;
            input.y = mgn;
            input.width = stage.stageWidth - mgn * 2;
            input.height = stage.stageHeight * 0.55;
            addChild(input);
            fmt.size = null;
            
            var w:Number = 60, h:Number = 20;
            var m:Matrix = new Matrix();
            m.createGradientBox(w, h, Math.PI/2);
            
            var btn:Sprite = new Sprite();
            btn.graphics.beginGradientFill("linear", [0x3FCFFF, 0xCFFFFF], [1,1], [0,255], m);
            btn.graphics.lineStyle(2, 0x02F4F, 0.3, true);
            btn.graphics.drawRoundRect(0, 0, w, h, 10);
            btn.buttonMode = true;
            btn.mouseChildren = false;
            btn.x = stage.stageWidth - w >> 1;
            btn.y = input.height + mgn * 2;
            addChild(btn);
            
            var ar:TextField = new TextField();
            fmt.align = "center";
            ar.defaultTextFormat = fmt;
            ar.text = "V";
            ar.width = w;
            ar.height = h;
            btn.addChild(ar);
            fmt.align = null;
            
            output = new TextField();
            fmt.size = 10;
            output.defaultTextFormat = fmt;
            output.wordWrap = true;
            output.border = true;
            output.x = mgn;
            output.y = btn.y + h + mgn;
            output.width = stage.stageWidth - mgn * 2;
            output.height = stage.stageHeight - (btn.y + h + mgn * 2);
            addChild(output);
            
            return btn;
        }
    }
}
