/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qVoR
 */

package {

        // implicit wormhole shape
        
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;


      [SWF(backgroundColor=0x000000, width=500, height=500)] 

       public class Wormhole extends MovieClip {
		private var matrix:Matrix3D;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var brush:BitmapData;
		private var canvas:BitmapData;
		private var dx:Number;
		private var dy:Number;


               public function Wormhole(){
                  // init
			matrix = new Matrix3D();
			verts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			uvts = new Vector.<Number>();
			for (var i:Number = -10; i<10; i+=.04) {
				for (var j:Number = -5; j<8; j+=.04) {
					for (var k:Number = -10; k<10; k+=.04) {
						var s:Number =  i * i * j + j * k * k;
						if (s <10 && s> 9.95) {
							verts.push(i * 20);
							verts.push(j * 20);
							verts.push(k * 20);
							pVerts.push(0),pVerts.push(0);
							uvts.push(0),uvts.push(0),uvts.push(0);
						}
					}
				}
			}
			brush=new BitmapData(3,2,true,0x41FFFFFF);
			canvas=new BitmapData(500,500,false,0x000000);
			addChild(new Bitmap(canvas));
			dx=0;
			dy=0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			dx += (mouseX - dx)/4;
			dy += (mouseY - dy)/4;
			matrix.identity();
			matrix.appendRotation(dy,Vector3D.X_AXIS);
			matrix.appendRotation(dx,Vector3D.Y_AXIS);
			matrix.appendTranslation(250, 250, 0);
			Utils3D.projectVectors(matrix, verts, pVerts, uvts);
			canvas.lock();
			canvas.fillRect(canvas.rect, 0x000000);
			var p:Point = new Point();
			for (var i:int = 0; i<pVerts.length; i+=2) {
				p.x = pVerts[i];
				p.y = pVerts[i+1];
				canvas.copyPixels(brush, brush.rect, p, null, null, true);
			}
			canvas.unlock();
		}
		

       }

}