/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qVn8
 */

package {
    import flash.text.TextField;
    import flash.display.AVM1Movie;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private const BAR_LENGTH:Number = 96;
        private const BAR_OFFSET:Number = 64;
        private const BALL_RADIUS:Number = 8;
        private const BALL_SPEED:Number = 4;
        
        private var ball_:Sprite;
        private var bar_:Sprite;
        private var ballVector_:Vector3D;
        private var ballPoint_:Point;
        
        public function FlashTest() {
            // write as3 code here..
            stage.frameRate = 60;
            
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void {
            // Background
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();

            // Bar
            bar_ = new Sprite();
            bar_.mouseEnabled = false;
            bar_.graphics.beginFill(0x3f3fff);
            bar_.graphics.drawRect(-BAR_LENGTH / 2, 0, BAR_LENGTH, 4);
            bar_.graphics.endFill();
            addChild(bar_);
            
            // Ball
            ball_ = new Sprite();
            ball_.mouseEnabled = false;
            ball_.graphics.beginFill(0xff3f3f);
            ball_.graphics.drawCircle(0, 0, BALL_RADIUS);
            ball_.graphics.endFill();
            addChild(ball_);
            
            // Button
            var btn:Sprite = createButtonButton("RESET");
            btn.addEventListener(MouseEvent.CLICK, onResetClick);
            btn.x = 0;
            btn.y = stage.stageHeight - btn.height;
            addChild(btn);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            reset();
        }
        
        private function reset(all:Boolean=true):void {
            ballPoint_ = new Point(stage.stageWidth / 2, stage.stageHeight - 32);
            ballVector_ = new Vector3D(0, -BALL_SPEED, 0);
            
            bar_.x = stage.stageWidth / 2;
            bar_.y = stage.stageHeight - BAR_OFFSET;
            ball_.x = ballPoint_.x;
            ball_.y = bar_.y - BALL_RADIUS;
        }

        
        private function checkHittingSide(type:String, x:Number, y:Number, radius:Number):Boolean {
            if (type == SideType.LEFT && x < radius) {
                return true;
            }
            else if (type == SideType.RIGHT && x > stage.stageWidth - radius) {
                return true;
            }
            else if (type == SideType.TOP && y < radius) {
                return true;
            }
            else if (type == SideType.BOTTOM && y > stage.stageHeight - radius) {
                return true;
            }

            return false;
        }
        
        private function checkHittingBar(x:Number, y:Number, radius:Number, barX:Number, barY:Number, length:Number):Boolean {
            if (barY < (y + radius)) {
                var lenD2:Number = length / 2;
                if (barX - lenD2 < x && x < barX + lenD2) {
                    return true;
                }
            }

            return false;
        }
        
        private function createButtonButton(text:String):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(0x3f3f3f);
            sp.graphics.drawRect(0,0, 128, 32);
            sp.graphics.endFill();
            
            var tf:TextField = new TextField();
            tf.mouseEnabled = false;
            tf.text = text;
            tf.width = tf.textWidth + 4;
            tf.height = tf.textHeight + 4;
            tf.x = sp.width / 2 - tf.width / 2;
            tf.y = sp.height / 2 - tf.height / 2;
            sp.addChild(tf);
            
            return sp;
        }

        private function onResetClick(e:MouseEvent):void {
            reset();
        }

        private function onMouseMove(e:MouseEvent):void {
            bar_.x = e.stageX;
        }

        private function onEnterFrame(e:Event):void {
            var preX:Number = ball_.x + ballVector_.x;
            var preY:Number = ball_.y + ballVector_.y;
            
            if (checkHittingSide(SideType.LEFT, preX, preY, BALL_RADIUS)) {
                ballVector_.x = Math.abs(ballVector_.x);
            }
            else if (checkHittingSide(SideType.RIGHT, preX, preY, BALL_RADIUS)) {
                ballVector_.x = -Math.abs(ballVector_.x);
            }
            else if (checkHittingSide(SideType.TOP, preX, preY, BALL_RADIUS)) {
                ballVector_.y = Math.abs(ballVector_.y);
            }
            else if (checkHittingSide(SideType.BOTTOM, preX, preY, BALL_RADIUS)) {
                ballVector_.y = -Math.abs(ballVector_.y);
            }
            else if (ballVector_.y > 0 && checkHittingBar(preX, preY, BALL_RADIUS, bar_.x, bar_.y, BAR_LENGTH)){
                var rate:Number = (preX - bar_.x) / (BAR_LENGTH / 2);
                ballVector_.x  = rate *8;
                ballVector_.y = -Math.abs(ballVector_.y);
            }
            else {
                ball_.x = preX;
                ball_.y = preY;
            }
            
            ballVector_.normalize();
            ballVector_.scaleBy(BALL_SPEED);
        }
    }

}

import flash.display.Sprite;
internal class Ball extends Sprite {
}

internal class SideType {
    public static const LEFT:String = "LEFT";
    public static const RIGHT:String = "RIGHT";
    public static const TOP:String = "TOP";
    public static const BOTTOM:String = "BOTTOM";
}
