/**
 * Copyright folbore ( http://wonderfl.net/user/folbore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qVQE
 */

// forked from kihon's flash on 2010-5-4
package
{
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class Main extends Sprite
    {
        private var canvas:Sprite;
        private var t:Number = 0.0;
        private var a:Point = new Point(200, 200);
        private var b:Point = new Point(300, 50);
        private var c:Point = new Point(400, 200);
        private var label:Label;
        
        public function Main()
        {
            label = new Label(this, 260, 220);
            label.scaleX = label.scaleY = 2;
            
            canvas = new Sprite();
            addChild(canvas);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            label.text = "t = " + t.toFixed(2);
            
            var ab:Point = Point.interpolate(b, a, t);
            var bc:Point = Point.interpolate(c, b, t);
            var f:Point = Point.interpolate(bc, ab, t);
            
            with (canvas)
            {
                graphics.clear();
                graphics.lineStyle(2.0, 0x0, 0.1);
                graphics.moveTo(a.x, a.y);
                graphics.lineTo(b.x, b.y);
                graphics.lineTo(c.x, c.y);
                graphics.moveTo(ab.x, ab.y);
                graphics.lineTo(bc.x, bc.y);
                
                graphics.lineStyle(2.0, 0x0);
                graphics.beginFill(0xFFFFFF);
                graphics.drawCircle(a.x, a.y, 5);
                graphics.drawCircle(b.x, b.y, 5);
                graphics.drawCircle(c.x, c.y, 5);
                graphics.endFill();
                
                graphics.beginFill(0xED1A3D);
                graphics.drawCircle(ab.x, ab.y, 5);
                graphics.drawCircle(bc.x, bc.y, 5);
                graphics.endFill();
                
                graphics.beginFill(0x009AD6);
                graphics.drawCircle(f.x, f.y, 5);
                graphics.endFill();
            }
            
            graphics.beginFill(0x0);
            graphics.drawCircle(f.x, f.y, 1);
            graphics.endFill();
            
            t += 0.002;
            
            if (t > 1.0)
            {
                graphics.clear();
                t = 0;
            }
        }
    }
}