/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qV5G
 */

// forked from NewKrok's Reflection
package {
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.DisplayObject;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        private var _imgs:Vector.<Bitmap> = new Vector.<Bitmap>;
        private var _loadedImages:uint = 0;
        private var _totalWidth:Number = 0;
        private const _imgCount:Number = 4;
        
        public function FlashTest() {
            var imageURL:String = "http://assets.wonderfl.net/images/related_images/1/11/11dc/11dc82145fde91ae6b2f30f421e543b4e7aaf9c0";
            for ( var i:uint; i < _imgCount; i++ )
                loadImage ( imageURL, imgLoaded );
        }
        
        private function loaded ( $img:Bitmap ) :void {
            $img.visible = false;
            $img.y = 465 / 2 - $img.height / 2;
            $img.x = _loadedImages * $img.width + _loadedImages * 1;
            _totalWidth += $img.width + 1;
            _loadedImages++;
            if ( _loadedImages == _imgCount ) {
                for ( var i:uint; i < _imgCount; i++ ) {
                    _imgs[i].visible = true;
                    addTween ( _imgs[i] );
                }
            }

        }
        
        private function addTween ( $target:DisplayObject ) :void {
            Tweener.addTween ( $target, { transition: "linear", time: 10 * ( $target.x / _totalWidth ), x: -$target.width, onComplete: resetPosition, onCompleteParams: [$target], onUpdate: Reflection.generate, onUpdateParams: [$target, 70, .5, 1] });
        }
        
        private function resetPosition ( $target:DisplayObject  ) :void {
            $target.x = _totalWidth;
            addTween ( $target );
        }


        private function loadImage ( $url:String, $onComplete:Function ) :void {
            var imageLoader:Loader = new Loader ();
            imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
            var image:URLRequest = new URLRequest ( $url );
            imageLoader.load ( image, new LoaderContext ( true ) );
        }
        
        private function imgLoaded ( event:Event ) :void {
             _imgs.push ( addChild ( new Bitmap ( new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 ) ) ) as Bitmap);
             _imgs[_imgs.length - 1].bitmapData.draw ( event.currentTarget.content );
             loaded ( _imgs[_imgs.length - 1] );
        }
        
    }
}
    
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.MovieClip
import flash.geom.Matrix;
import flash.geom.Rectangle
import flash.geom.ColorTransform;
class Reflection {
    
    private static var transformMatrix:    Matrix
    private static var ct:                ColorTransform = new ColorTransform ()
            
    private static var reflections:        Array = new Array ()
    
    private static const rotate:        Number = .5 * Math.PI
    
    public function Reflection () :void {
    }        
    
    /**
     * Make reflect for displayobject
     * @param Target The selected displayobject
     * @param Height The height of reflection
     * @param Alpha The starting Alpha
     * @param YOffset The y offset of reflection
     * @param AlphaStep The step of alpha decrease ( the lower is better )
     */
    public static function generate ( Target:DisplayObject, Height:Number = 100, Alpha:Number = .8, YOffset:Number = 0, AlphaStep:Number = 1 ) :void {
        
        var selectedReflect:Object = getReflectionInfo ( Target )
        if ( selectedReflect )
            selectedReflect.reflection.bitmapData = new BitmapData ( Target.width, Height, true, 0x60 )
        else {
            reflections.push ( { reflection: new Bitmap ( new BitmapData ( Target.width, Height, true, 0x60 ) ) , target: Target } )
            selectedReflect = reflections[reflections.length - 1] 
        }
        transformMatrix = new Matrix ()
        transformMatrix.scale ( 1, -1 )
        transformMatrix.translate ( 0, Target.height )
        selectedReflect.reflection.bitmapData.draw ( Target, transformMatrix )
        
        selectedReflect.reflection.x = Target.x
        selectedReflect.reflection.y = Target.y + Target.height + YOffset

        var rec:Rectangle = new Rectangle ( 0, 0, Target.width, AlphaStep )
        var ratio:Number = Alpha / Height
        var i:int = 0
        while ( i < Height ) {
            rec.y = i
            ct.alphaMultiplier = Alpha - ( i * ratio )
            selectedReflect.reflection.bitmapData.colorTransform ( rec, ct )
            i += AlphaStep
        }
        
        Target.parent.addChild ( selectedReflect.reflection )
    
    }

    private static function getReflectionInfo ( Target:DisplayObject ) :Object {
    
        for each ( var info:Object in reflections ) {
            if ( info.target == Target )
                return info
        }
        
        return null
        
    }
    
    /**
     * Remove reflection from target
     * @param Target The selected target.
     */
    public static function remove ( Target:DisplayObject ) :void {
    
        var i:int = 0
        while ( i < reflections.length ) {
            if ( reflections[i].target == Target ) {
                Target.parent.removeChild ( reflections[i].reflection )
                reflections.splice ( i, 1 )
                break
            }
            i++
        }
        
    }
    
}