/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qUeR
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    import frocessing.color.FColor;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    
    public class FlashTest extends BasicView {
        private const p:int = 3;
        private const q:int = 7;
        private const a:int = 100;
        private const l:Number = 0.9;
        private const m:Number = 1.1;
        
        private var pixels:Pixels;
        private var canvas:BitmapData;
        private var mtx:Matrix;
        
        public function FlashTest() {
            super(0, 0, true, true);
            
            var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465, true, 0, "clear_pre", true);
            layer.clearBeforeRender = true;
            viewport.containerSprite.addLayer(layer);
            
            camera.z = -500;
            
            pixels = new Pixels(layer);
            scene.addChild(pixels);
            
            var c:int = 0;
            var cc:FColor = new FColor;
            
            for(var i:Number=0; i<=6 * Math.PI; i += 0.02)
            {
                var xx:Number = (2+Math.cos(q/p*i)) * Math.cos(i) * a;
                var yy:Number = Math.sin(q/p*i)*a*1.6;
                var zz:Number = (2+Math.cos(q/p*i)) * Math.sin(i) * a;
                
                cc.hsv(c, 1, 1);
                var color:uint = cc.value32;
                
                for(var j:int=0; j < 15; j++) {
                    var px:Pixel3D = new Pixel3D(color, xx * ((m-l) * Math.random()+l), yy*((m-l)*Math.random()+l), zz*((m-l)*Math.random()+l));
                    pixels.addPixel3D(px);
                }
                c+=2;
            }
            
            canvas = new BitmapData(465 / 4, 465 / 4, false, 0x000000);
            var bmp:Bitmap = new Bitmap(canvas, "never", true);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            mtx = new Matrix(0.25, 0, 0, 0.25);
            
            addEventListener(Event.ENTER_FRAME, onFrame);            
        }
        
        private function onFrame(e:Event):void
        {
            canvas.fillRect(canvas.rect, 0x000000);
            canvas.draw(viewport, mtx);
            
            pixels.rotationY+=0.2;
            singleRender();
        }

    }
}