/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qUa1
 */

// forked from tkinjo's ボールを投げる
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main10 extends Sprite 
    {
        private const AFTER_IMAGE_COLOR_TRANSFORM:ColorTransform = new ColorTransform( 1, 1, 1, 0.2 );
        
        private var ball:Ball;
        private var motionBlur:BlurFilter;
        
        private var afterImageBitmapData:BitmapData;
        private var afterImage:Bitmap;
        
        public function Main10():void 
        {
            ball = new Ball( 20, new Rectangle( 0, 0, stage.stageWidth, stage.stageHeight ) );
            addChild( ball );
            
            afterImageBitmapData = new BitmapData( stage.stageWidth, stage.stageHeight );
            afterImage = new Bitmap( afterImageBitmapData );
            addChild( afterImage );
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            afterImageBitmapData.lock();
            
            afterImageBitmapData.colorTransform( afterImageBitmapData.rect, AFTER_IMAGE_COLOR_TRANSFORM );
            afterImageBitmapData.draw( this );
            
            afterImageBitmapData.unlock();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class Ball extends Sprite {
    
    private var SPEED_THRESHOLD:Number = 0.1;
    private var FRICTION:Number = 0.05;
    
    private var _speed:Point = new Point();
    public function get speed():Point { return _speed; }
    
    private var previousX:Number = 0;
    private var previousY:Number = 0;
    
    private var mouseDown:Boolean;
    
    private var radius:Number;
    
    private var field:Rectangle;
    
    public function Ball( radius:Number = 20, field:Rectangle = null ):void 
    {
        this.radius = radius;
        this.field = field;
        
        graphics.beginFill( 0 );
        graphics.drawCircle( 0, 0, radius );
        graphics.endFill();
        buttonMode = true;
        
        addEventListener(MouseEvent.MOUSE_DOWN, ballMouseDownHandler);
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function enterFrameHandler( event:Event ):void {
        
        if ( !mouseDown ) {
            
            speed.x += -speed.x * FRICTION;
            speed.y += -speed.y * FRICTION;
            
            if ( Math.abs( speed.x ) < SPEED_THRESHOLD )
                speed.x = 0;
            
            if ( Math.abs( speed.y ) < SPEED_THRESHOLD )
                speed.y = 0;
        } else {
            
            speed.x = x - previousX;
            speed.y = y - previousY;
        }
        
        previousX = x;
        previousY = y;
        
        
        
        if ( mouseDown )
            return;
            
        x += speed.x;
        y += speed.y;
        
        
        
        if ( !field )
            return;
        
        if ( x < radius ) {
            
            x = radius;
            speed.x = -speed.x;
        }
        
        if ( field.width - radius < x ) {
            
            x = field.width - radius;
            speed.x = -speed.x;
        }
        
        if ( y < radius ) {
            
            y = radius;
            speed.y = -speed.y;
        }
        
        if ( field.height - radius < y ) {
            
            y = field.height - radius;
            speed.y = -speed.y;
        }
    }
    
    private function ballMouseDownHandler( event:MouseEvent ):void {
        
        mouseDown = true;
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
    }
    
    private function stageMouseMoveHandler( event:MouseEvent ):void {
        
        x = parent.mouseX;
        y = parent.mouseY;
    }
    
    private function stageMouseUpHandler( event:MouseEvent ):void {
        
        mouseDown = false;
        
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.removeEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
    }
}
