/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qTmm
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import frocessing.math.Random;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Wait;
	import com.bit101.components.PushButton;
	
	public class Main extends Sprite
	{
		private var data:Array;
		private var SIZE:int = 5;
		private var num:int = 80;
		private var list:SerialList = new SerialList();
		private var copy:Array;
		
		public function Main()
		{
			graphics.beginFill(0xF0F0F0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			data = new Array(num);
			for (var i:int = 0; i < data.length; i++)
			{
				var rect:Rect = new Rect(SIZE);
				rect.x = i * SIZE;
				rect.y = i * SIZE;
				addChild(rect);
				data[i] = rect;
			}
			init();

			new PushButton(this, 185, 400, "execute", execute);
		}
		
		private function execute(event:Event):void
		{
			if (list.state == 2) return;
			list = new SerialList();
			
			init();
			sort(0, data.length - 1);
			list.execute();
		}
		
		private function init():void
		{
			var random:Array = Random.shakedIntegers(num);
			for (var i:int = 0; i < data.length; i++)
			{
				data[i].x = random[i] * SIZE;
			}
			
			copy = new Array(num);
			for (i = 0; i < data.length; i++)
			{
				copy[i] = data[i].x;
			}
		}
		
		private function sort(left:int, right:int):void
		{
			var l:int = left;
			var r:int = right;
			var pivot:int = copy[int((left + right) / 2)];
			
			do
			{
				while (copy[l] < pivot) l++;
				while (copy[r] > pivot) r--;
				
				if (l <= r)
				{
					list.addCommand(new Func(function(l:int, r:int):void { var temp:int = data[l].x; data[l].x = data[r].x; data[r].x = temp; }, [l, r]));
					list.addCommand(new Wait(40 / 1000.0));
					
					var temp:int = copy[l];
					copy[l] = copy[r];
					copy[r] = temp;
					
					l++, r--;
				}
			} while (l <= r);
			
			if (l < right)
				sort(l, right);
			if (left < r)
				sort(left, r);
		}
	}
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;

class Rect extends Sprite
{
	public function Rect(size:int)
	{
		graphics.beginFill(0x0);
		graphics.drawRect(0, 0, size, size);
		graphics.endFill();
		
		this.filters = [new DropShadowFilter(2)];
	}
}