/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qTXB
 */

/*
なんかいろいろいじってみただけ
startを押すとなんか始まります
方向キーとｚ、shiftキーを押すとあっちのほうと自分の方にきます
ただそれだけです
プレビューで見たほうがわかりやすいと思います
*/


package
{

    import caurina.transitions.Tweener;

    import fl.transitions.Transition;

    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;

    import frocessing.color.ColorRGB;

    import org.flintparticles.common.actions.ColorChange;
    import org.osmf.display.ScaleMode;
    import org.papervision3d.core.clipping.FrustumClipping;
    import org.papervision3d.core.render.filter.FogFilter;
    import org.papervision3d.core.render.sort.NullSorter;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.special.FogMaterial;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.render.QuadrantRenderEngine;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.view.BasicView;


    public class game2 extends BasicView
    {
        private var bv:BasicView;
        private var plane1:Plane;
        private var plane2:Plane;
        private var paper:PaperPlane;
        private var N:Number=3000;
        private var yk:Number=0, xk:Number=0, cz:Number=-175, rz:Number=0;
        private var z_flag:Boolean=false, mouse_flag:Boolean=false;
        private var p:Plane;
        private var word:Text3D;
        private var default_t:Number=0, tamakazu:Number=0;
        private var tama_array:Array=[];
        //private var tama:Tama;
        private const M_tama:Number=256;
        private const T_tama:Number=1024;


        public function game2()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            bv=new BasicView(0, 0, true);
            bv.viewport.interactive=true;
            super(0, 0, true, true);
            addChild(bv);

            var fog:FogMaterial=new FogMaterial(0xDDEEFF);
            gamemain();
            menu();
            //makeTama();
            renderer.filter=new FogFilter(fog, 10, 1000, 1700);
            renderer.clipping=new FrustumClipping(FrustumClipping.BOTTOM);
            startRendering();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, key_down);
            stage.addEventListener(KeyboardEvent.KEY_UP, key_up);
            bv.addEventListener(MouseEvent.MOUSE_OVER, mouseup);
            bv.addEventListener(MouseEvent.MOUSE_OUT, outmouse);
            bv.addEventListener(MouseEvent.CLICK, click);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        public function gamemain():void
        {
            var color:ColorMaterial=new ColorMaterial(0xEEEEEE);
            var wireframe:WireframeMaterial=new WireframeMaterial(0x0044FF);
            var mix:CompositeMaterial=new CompositeMaterial();
            mix.addMaterial(wireframe);
            mix.addMaterial(color);
            mix.doubleSided=true;
            wireframe.doubleSided=true;
            color.doubleSided=true;
            plane1=new Plane(wireframe, N, N, 12, 12);
            plane2=new Plane(wireframe, N, N, 12, 12);
            paper=new PaperPlane(mix, 0);
            Init();
            scene.addChild(plane1);
            scene.addChild(plane2);
            scene.addChild(paper);
        }

        public function menu():void
        {
            var fonts:HelveticaBold=new HelveticaBold();
            var mat:Letter3DMaterial=new Letter3DMaterial(0x0000FF, 0.5);
            var pm:ColorMaterial=new ColorMaterial(0x3388FF, 0.5);
            pm.interactive=true;

            mat.doubleSided=true;
            pm.doubleSided=true;
            word=new Text3D("START", fonts, mat);
            p=new Plane(pm, 400, 400, 1, 1);
            bv.scene.addChild(p);
            bv.scene.addChild(word);
            bv.renderer=new QuadrantRenderEngine();
            bv.startRendering();
        }

        public function Init():void
        {
            paper.rotationX=355;
            plane1.rotationX=90;
            plane2.rotationX=90;
            plane1.y=-200;
            plane2.z=N;
            plane2.y=-200;
            camera.z=paper.z - 150;
            camera.x=500;
        }

        public function key_down(e:KeyboardEvent):void
        {
            if (e.keyCode == 38)
                if (paper.y < 500)
                    yk+=30;
            if (e.keyCode == 40)
                if (paper.y > -80)
                    yk-=30;
            if (e.keyCode == 39)
            {
                rz=-30;
                if (paper.x < 1400)
                    xk+=30;
            }
            if (e.keyCode == 37)
            {
                rz=30;
                if (paper.x > -1400)
                    xk-=30;
            }
            if (e.keyCode == 90)
                cz+=-50;

            if (e.keyCode == 16)
                cz+=50;
            if (e.keyCode == 88)
            {
                //makeTama();
            }


        }

        public function key_up(e:KeyboardEvent):void
        {
            if (e.keyCode == 39 || e.keyCode == 37)
                rz=0;
            if (e.keyCode == 88)
                tamakazu=0;
        }

        public function outmouse(e:MouseEvent):void
        {
            Tweener.addTween(p, {scaleX: 1, time: 1.0, transition: "easeOutElastic"});
            Tweener.addTween(word, {scaleX: 1, time: 1.0, transition: "easeOutElastic"});
        }

        public function mouseup(e:MouseEvent):void
        {
            Tweener.addTween(p, {scaleX: 2, time: 1.0, transition: "easeOutElastic"});
            Tweener.addTween(word, {scaleX: 2, time: 1.0, transition: "easeOutElastic"});

        }

        public function click(e:MouseEvent):void
        {
            mouse_flag=true;
            bv.scene.removeChild(p);
            bv.scene.removeChild(word);
        }

        public function default_loop():void
        {
            plane1.z-=20;
            plane2.z-=20;
            if (plane1.z < -N)
                plane1.z=plane2.z + N;
            if (plane2.z < -N)
                plane2.z=plane1.z + N;
        }

        public function default_move():void
        {
            if (mouse_flag)
            {
                var rateX:Number=(mouseX + paper.x) / stage.stageWidth;
                var rateY:Number=(mouseY - paper.y) / stage.stageHeight;
                var targetX:Number=-200 * (rateX - 0.5);
                var targetY:Number=200 * (rateY - 0.5);
                camera.x+=(targetX - camera.x) * 0.3;
                camera.y+=(targetY - camera.y) * 0.3;
                camera.z+=(cz - camera.z) * 0.2;
                paper.rotationZ+=(rz - paper.rotationZ) * 0.2;

                paper.y+=(yk - paper.y) * 0.2;
                paper.x+=(xk - paper.x) * 0.2;
            }
            else
            {
                default_t++;
                camera.x=500 * Math.cos(default_t * Math.PI / 180);
                camera.z=500 * Math.sin(default_t * Math.PI / 180);
                word.rotationY+=1;
                word.rotationX+=3;
                word.rotationZ+=2;
                p.rotationX+=2;
                p.rotationZ+=3;
            }

        }
/*
        public function makeTama():void
        {
            for (var i:Number=0; i < tamakazu; i++)
            {
                var tama:Tama=new Tama(5, 5, 5, paper.x, paper.y, paper.z, 1);
                tama_array.push(tama.sp);
                scene.addChild(tama.sp);
            }
            var tama:Tama=new Tama(5, 5, 5, paper.x, paper.y, paper.z, 1);
            tama=new Tama(5, 5, 5, paper.x, paper.y, paper.z, 1);
            tama_array.push(tama.sp);
            scene.addChild(tama.sp);
        }

        public function moveTama():void
        {
            //for (var i:Number=0; i < tamakazu; i++)
            //{
            //tama_array[i].z+=30;
            //if(tama_array[i].sp.z > 1500)
            //scene.removeChild(tama_array[i].sp);
            //}
            //tama_array[0].z += 20;

        }
*/
        public function onEnterFrame(e:Event):void
        {
            default_loop();
            default_move();
            //tama.sp.z+=20;
            //moveTama();

        }

    }
}