/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qTGw
 */

// forked from mousepancyo's ビリビリ（Lightning Effect）
/*
比較的簡単に実装できそうな方法で
稲妻というか放電風のビリビリを作ってみました。

マウスクリックでビリビリの出現点が変化します。
*/

package {
    import flash.filters.BlurFilter;    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.filters.GlowFilter;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="70")]
    
    public class Main extends Sprite{
        private const W:Number = 465;
        private const H:Number = 465;
        private const RANGE:int = 5;
        private var _p:Point;
        private var _sp:Sprite;
        private var _ctf:ColorTransform;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var blur:BlurFilter
        private var timer:int

        public function Main() {
            init();
            addEventListener(Event.ENTER_FRAME, update)    ;
            stage.addEventListener(MouseEvent.CLICK, onDown);
        }
        
        private function init():void{
            _p = new Point(W / 2, 30);
            _sp = new Sprite();
            _sp.filters = [new GlowFilter(0xC9E6FC, 1, 10, 10, 4, 3, false, false)];
            _ctf = new ColorTransform(0.9, 0.96, 1, 0.9);
            _canvas = new BitmapData(W,H,false,0);
            blur=new BlurFilter(1,1,15)
            var bm:Bitmap = new Bitmap(_canvas, "auto", true);
            _glow = new BitmapData(W / RANGE, H / RANGE, false, 0);
            
            var glowBm:Bitmap = new Bitmap(_glow, "never", true);
            glowBm.blendMode = "add";
            glowBm.scaleX = glowBm.scaleY = RANGE;
            
            addChild(bm);
           addChild(glowBm);
        }
        private function clapper(pos:Point,spread:Number):void{
            var p:Point = new Point();
             _sp.graphics.clear();
              var num:int = Math.random() * .7;
              
           for(var x:int=0;x<2;x++){

                p.x = pos.x;
            p.y = pos.y;
            _sp.graphics.lineStyle(num, 0xFFFFFF, 1-num);
            _sp.graphics.moveTo(p.x, p.y);
           
            var i:int = p.y;
            var n:int = 1
            while(i < H){
                n*=1.1+spread/8
                i += n;
                p.y = i;
                p.x += (Math.random() * (n * spread) - n*spread/2);
                _sp.graphics.lineTo(p.x, p.y);
            }
            }
        }

        private function onDown(e:MouseEvent):void{
            _p = new Point(mouseX, mouseY);
           clapper(_p,2)
           timer=2+Math.random()*10
           addEventListener(Event.ENTER_FRAME,second)
        }
        private function second(e:Event):void{
            timer--
            if(timer<0){
                clapper(_p,6)
                removeEventListener(Event.ENTER_FRAME,second)
            }

        }

        private function update(e:Event):void{
            _canvas.colorTransform(_canvas.rect, _ctf);
            _canvas.draw(_sp);
            _canvas.applyFilter(_canvas,_canvas.rect,new Point(0,0),blur)
            _glow.draw(_canvas, new Matrix(1 / RANGE, 0, 0, 1 / RANGE));
            _sp.graphics.clear()
        }
    }
}