/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qRwt
 */

// forked from omochieater's getQualifiedClassNameの処理速度
package 
{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    import flash.display.BitmapData;
    import flash.system.System;
    import flash.utils.getDefinitionByName;
    import flash.utils.getQualifiedClassName;
    import flash.utils.getQualifiedSuperclassName;
    /**
     * 変数宣言をしてからのループと変数宣言を含むループの処理速度比較
     * ※計測処理の構造は、muta244氏を参考にさせていただきました。
     */
    public class Main extends Sprite {
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            setup();
            exec();
        }
        
        private function exec():void {
            var memory:uint;
            var NUM_TIMES:uint = 262144;
            var _Shape:Class = getDefinitionByName("flash.display.Shape")　as Class;

            debug(
                "各テスト" + NUM_TIMES + "回処理させた結果 [単位：ミリ秒]\n" +
                "（誤差は多少生じます）\n"
            );
            measure("Shapeクラスを" + NUM_TIMES + "回getQualifiedClassNameで比較した結果", function():void {
                var object:Object = new Shape();
                for (var i:uint = 0; i < NUM_TIMES; ++i) {
                    getQualifiedClassName(object) == "Shape";
                }
            });
            measure("ShapeクラスをgetDefinitionByName経由で" + NUM_TIMES + "回比較した結果", function():void {
                for (var i:uint = 0; i < NUM_TIMES; ++i) {
                    getQualifiedClassName(_Shape) == "Shape";
                }
            });
            measure("Shapeクラスを" + NUM_TIMES + "回getQualifiedSuperclassNameで比較した結果", function():void {
                var object:Object = new Shape();
                for (var i:uint = 0; i < NUM_TIMES; ++i) {
                    getQualifiedSuperclassName(object) == "flash.display.DisplayObject";
                }
            });
        }
        
        private function measure(title:String, func:Function, ...params):void {
            mTime = getTimer();
            func.apply(this, params);
            mTime = getTimer() - mTime;
            debug("[" + title + "] --> " + mTime + "ms");
        }
        
        private function debug(log:String):void {
            mTextField.appendText(log + "\n");
        }
        
        private function setup():void {
            mTextField = new TextField();
            mTextField.width = stage.stageWidth - 40;
            mTextField.height = stage.stageHeight - 60;
            mTextField.x = 20;
            mTextField.y = 60;
            mTextField.multiline = true;
            mTextField.wordWrap = true;
            
            var textFormat:TextFormat = mTextField.defaultTextFormat;
            textFormat.font = "_sans";
            mTextField.defaultTextFormat = textFormat;
            
            addChild(mTextField);
            
            var button:TextField = new TextField();
            button.x = 20;
            button.y = 20;
            button.htmlText = "<p align='center'><fontface='_sans'>再計算</fontface></p>";
            button.background = true;
            button.backgroundColor = 0xEEEEEE;
            button.border = true;
            button.borderColor = 0xBBBBBB;
            button.width = 100;
            button.height  = 20;
            button.selectable = false;
            
            addChild(button);
            
            button.addEventListener(MouseEvent.CLICK, function():void {
                mTextField.text = "";
                exec();
            });
        }

        private var mTime:uint;
        private var mTextField:TextField;
        
    }
}

