/**
 * Copyright ffffine ( http://wonderfl.net/user/ffffine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qR6r
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.CurveModifiers;
    import flash.geom.ColorTransform;

    [SWF(width = "465", height = "465", color ="0x000000" , frameRate = "30")];
    

    public class Main extends Sprite 
    {    
        private var _particles:Array = [];
        private var _max:int = 10;
        private var _canvas:Bitmap;
        private var _bmpData:BitmapData;
        private var _colortransform:ColorTransform;
        private var _isPressing:Boolean = false;
        private var _my:Number=0;
        private var _mx:Number = 0;
        private var _spring:Number = 0.2;
        private var _friction:Number = 0.85;
        private var _vx:Number=0;
        private var _vy:Number=0;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            CurveModifiers.init();
            trace(stage.width);
            _bmpData = new BitmapData(465,465, false, 0x000000);
            _canvas = new Bitmap(_bmpData, "auto", true);
            _colortransform = new ColorTransform(0.8, 0.8, 0.8);
            addChild(_canvas);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(Event.ENTER_FRAME, xEnterFrame);
        }
        
        private function onMouseDown(e:MouseEvent):void 
        {
            _isPressing = true;
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseUp(e:MouseEvent):void 
        {
            _isPressing = false;
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        private function xEnterFrame(e:Event):void 
        {            
            if (_isPressing) {
            var targetX:Number = mouseX;
            var targetY:Number = mouseY;                
            _vx += (targetX - _mx) * _spring;
            _vy += (targetY - _my) * _spring;
            _mx += (_vx *= _friction);
            _my += (_vy *= _friction);
                for (var i:int = 0; i < _max ; i++) 
                {
                    var p:Particle = new Particle(Math.floor(Math.random()*20)-10+_mx , Math.floor(Math.random()*20-10)+_my);
                    addChild(p);
                    Tweener.addTween(p, { x:p.dx, y:p.dy,time:1,scaleX:0.1,scaleY:0.1, alpha:0, rotation:0, _bezier:[{x:p.cx,y:p.cy}],transition:"easeOutSine",onComplete:xRemoveChild,onCompleteParams:[p] } );
                }                
            }
            _bmpData.draw(stage);
            _bmpData.colorTransform(_bmpData.rect, _colortransform);
        }
        
        private function xRemoveChild(p:Shape):void
        {
            removeChild(p);
        }
        
    }
    
}
import flash.display.Shape;
import flash.geom.Point;
import flash.display.BlendMode;
import flash.filters.BlurFilter;

class Particle extends Shape {
    
    public var dx:Number;
    public var dy:Number;
    public var cx:Number;
    public var cy:Number;
    
    public function Particle(xx:int,yy:int):void {
        graphics.clear();
        graphics.beginFill(Math.random()*0xFFFFFF);
        graphics.drawRect(0, 0, Math.floor(Math.random()*20)+15,Math.floor(Math.random()*20)+15);
        graphics.endFill();
        rotation = Math.random() * 360;
        x = xx;
        y = yy;
        dx = xx +(Math.floor(Math.random() * 300) - 150);
        dy = yy +(Math.floor(Math.random() * 200) - 200);
        cx = dx;
        cy = yy -(Math.floor(Math.random() * 500) );
        blendMode = BlendMode.ADD;
        filters = [new BlurFilter(4,4,2)];
    }
}