/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qQxK
 */

package  {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.ActivityEvent;
	import flash.events.Event;	
	import flash.media.Camera;
	import flash.media.Microphone;
	import flash.media.Video;	
	
	public class Main extends MovieClip {		
		static private var CAMERA_WIDTH:uint = 640;
		static private var CAMERA_HEIGHT:uint = 480;
		static private var CAMERA_FLIP:Boolean = true;
		static private var FRAMERATE:int = 30;
		static private var MICROPHONE_GAIN:int = 66;
		
		private var video:Video;
		private var camera:Camera;
		private var mic:Microphone;		
		
		public function Main() {
			// constructor code
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		//________________________________________________________ INIT
		private function init(e:Event = null):void 
		{			
			removeEventListener(Event.ADDED_TO_STAGE, init);		
			
			stage.scaleMode	= StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;	
			stage.showDefaultContextMenu = false;
			
			
			video = new Video(CAMERA_WIDTH, CAMERA_HEIGHT);
			video.smoothing = true;			
			addChild(video);
			
			if (CAMERA_FLIP) {
				video.scaleX = -1;
				video.x = CAMERA_WIDTH;
			}
			
			
			camera = Camera.getCamera();
			
			if (camera == null) {
				trace("No camera is installed.");
			} else {				
				camera.setQuality(0, 100);
				camera.setMode(CAMERA_WIDTH, CAMERA_HEIGHT, FRAMERATE, false);
				camera.setMotionLevel(0, 500);
				
				camera.addEventListener(ActivityEvent.ACTIVITY, camActivityhandler);
				video.attachCamera(camera);			
			}
			
			mic = Microphone.getMicrophone();
			mic.setSilenceLevel(3);
			mic.gain = MICROPHONE_GAIN;
			mic.setUseEchoSuppression(true); 			
			mic.setLoopBack(false);
			mic.rate = 44;
		}
		
		private function camActivityhandler(event:ActivityEvent):void
		{
			//trace("motion activating: " + event.activating + " (" + camera.activityLevel + ")");			
		}
		
	}
	
}
