/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qQHG
 */

package{
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author www0z0k
     */
    public class Main extends Sprite {
        private var start:Sprite = new Sprite();
        private var stop:Sprite = new Sprite();
        
        private var indicator:Shape = new Shape();
        public function Main() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void     {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addChild(indicator);
            addChild(start);
            addChild(stop);
            
            with(start.graphics){
                beginFill(0x0000ff);
                drawRect(0, 0, 10, 15);
                endFill();
            }
            with(stop.graphics){
                beginFill(0xff00ff);
                drawRect(0, 0, 10, 15);
                endFill();
            }
            with(indicator.graphics){
                beginFill(0xff0000);
                drawRect(0, 0, 1, 15);
                endFill();
            }
            
            start.y = stop.y = indicator.y = 100;
            
            stop.buttonMode = true;
            stop.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stop.addEventListener(MouseEvent.MOUSE_UP, onUp);    
            stage.addEventListener(MouseEvent.RELEASE_OUTSIDE, onUp);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        
        private function onDown(e:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);    
        }
        
        private function onUp(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
        }
        
        private function onMove(e:MouseEvent):void {
            //check for valid numbers
            stop.x = e.stageX >= 0 && e.stageX < 300 ? e.stageX : stop.x;
            indicator.scaleX = stop.x;
        }
    }
}