/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qPml
 */

// forked from fluxus's forked from: PULP
// forked from spanvega's PULP
package
{
    /*
    * HIT SPACE BAR TO UPLOAD A TRACK
    * CLICK TO INVERT FLUX DIRECTION
    * 
    * ADDITIONAL FILTERS AVAILABLE
    * SHORTCUTS KEY
    * 
    * A : IDENTITY (NORMAL)
    * Z : CONTRAST
    * E : EMBOSS
    * R : NEGATIVE
    * T : SATURATION
    * Y : OUTLINE
    */

    import flash.geom.Point;
    import flash.geom.Matrix;

    import flash.text.TextField;

    import flash.net.URLRequest;
    import flash.net.FileFilter;
    import flash.net.FileReference;

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BlendMode;
    import flash.display.BitmapData;
    import flash.filters.BitmapFilter;

    import flash.media.Sound;
    import flash.media.ID3Info;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;

    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.events.KeyboardEvent;
    import flash.events.ProgressEvent;
    import flash.events.SecurityErrorEvent;

    /**
    *    @author SPANVEGA // CHRISTIAN
    **/

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '25')]

    public class PULP extends Sprite
    {
        private var pixel : BitmapData;
        private var model : BitmapData;
        private var clone : BitmapData;

        private var filter : BitmapFilter;
        private var bitmap : Bitmap;

        private var mat_01 : Matrix;
        private var mat_02 : Matrix;
        private var mat_03 : Matrix;
        private var mat_04 : Matrix;
        private var mat_05 : Matrix;
        private var mat_06 : Matrix;
        private var mat_07 : Matrix;
        private var mat_08 : Matrix;

        private var bdM_01 : String;
        private var bdM_02 : String;

        private var stageW : uint;
        private var stageH : uint;

        private var wInit : uint = 255;
        private var sizeW : uint;
        private var sizeH : uint;

        // --o PERLIN NOISE PROPERTIES

        private var pn_off : Point = new Point ();
        private var pn_val : Point = new Point ();
        private var pn_inv : Boolean = false;

        private var pn_bsX : Number;
        private var pn_bsY : Number;
        private var pn_rsd : int;

        // --o SOUND DERIVED PROPERTIES

        private var track : String = 'http://mm4d.free.fr/tracks/sample_flt.mp3';

        private var sLoad : FileReference;
        private var sChan : SoundChannel;
        private var lPeak : Number;
        private var rPeak : Number;
        private var sTags : String;
        private var sound : Sound;

        private var gLoad : GRAPHIC_BAR;
        private var lChan : GRAPHIC_BAR;
        private var rChan : GRAPHIC_BAR;
        private var infos : TextField;
        private var plays : TextField;


        public function PULP ()
        {
            Wonderfl.disable_capture();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init () : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            stageW = stage.stageWidth;
            stageH = stage.stageHeight;

            stage.scaleMode = 'noScale';

            sizeW = Math.round (stageW / 2);
            sizeH = Math.round (stageH / 2);

            //

            mat_01 = new Matrix
            (
                1, 0, 1, 1, -sizeW, 0
            );
            mat_02 = new Matrix
            (
                0, 1, 1, 1, 0, -sizeH
            );
            mat_03 = new Matrix
            (
                0, 1, -1, 1, sizeW * 2, -sizeH
            );
            mat_04 = new Matrix
            (
                -1, 0, -1, 1, sizeW * 3, 0
            );
            mat_05 = new Matrix
            (
                -1, 0, -1, -1, sizeW * 3, sizeH * 2
            );
            mat_06 = new Matrix
            (
                0, -1, -1, -1, sizeW * 2, sizeH * 3
            );
            mat_07 = new Matrix
            (
                0, -1, 1, -1, 0, sizeH * 3
            );
            mat_08 = new Matrix
            (
                1,  0, 1, -1, -sizeW, sizeH * 2
            );

            bdM_01 = BlendMode.INVERT;

            bdM_02 = BlendMode.MULTIPLY;

            filter = FILTER.identity ();

            //

            pn_bsX =  100 + Math.random () * 50;
            pn_bsY =  100 + Math.random () * 50;
            pn_rsd = -500 + Math.random () * 1000;

            //

            model = new BitmapData
            (
                sizeW, sizeH, false
            );

            pixel = new BitmapData
            (
                stageW, stageH, false
            );

            // RENDER TWICE ON START TO DISABLE MINOR 
            // WHITE SPACES BETWEEN SOME BITMAP PARTS

            onRender ();
            onRender ();

            //

            clone = pixel.clone ();

            clone.applyFilter
            (
                pixel, pixel.rect, new Point (0, 0), FILTER.brightness(wInit)
            );

            bitmap = new Bitmap (clone);

            addChild (bitmap);

           // --o SOUND DERIVED INSTANCES

            infos = new TextField ();
            infos.selectable = false;
            infos.autoSize = 'left';
            infos.x = 7;
            infos.y = stageH - 24;

            addChild (infos);

            //

            plays = new TextField ();
            plays.selectable = false;
            plays.autoSize = 'right';
            plays.x = stageW - 11;
            plays.y = 5;

            addChild (plays);

            //

            gLoad = new GRAPHIC_BAR
            (
                10, stageH - 30,
                stageW / 2 - 10, 2, 'H'
            );
            gLoad.visible = false;

            addChild (gLoad);

            lChan = new GRAPHIC_BAR
            (
                stageW - 23, stageH - 9,
                0, 2, 'V'
            );

            addChild (lChan);

            rChan = new GRAPHIC_BAR
            (
                stageW - 11, stageH - 9,
                0, 2, 'V'
            );

            addChild (rChan);

            //

            sound = new Sound ();

            sound.addEventListener (Event.ID3, onID3);
            sound.addEventListener (Event.OPEN, onOpen);
            sound.addEventListener (Event.COMPLETE, onComplete);
            sound.addEventListener (IOErrorEvent.IO_ERROR, onIOError);
            sound.addEventListener (ProgressEvent.PROGRESS, onProgress);
            sound.addEventListener (SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
            sound.load
            (
                new URLRequest (track),
                new SoundLoaderContext (1000, true)
            ); 

            //

            stage.addEventListener (Event.ENTER_FRAME, onFade);

            stage.addEventListener (MouseEvent.CLICK, onClick);
        
            stage.addEventListener (KeyboardEvent.KEY_DOWN, onKey);
        }

        private function onFade (e : Event) : void
        {
            if (wInit > 0)
            {
                clone.applyFilter
                (
                    pixel, pixel.rect, new Point (0, 0), FILTER.brightness(wInit-=2.5)
                );

                bitmap.bitmapData = clone;
            }
            else
            {
                bitmap.bitmapData = pixel;

                clone.dispose ();

                stage.removeEventListener (Event.ENTER_FRAME, onFade);

                stage.addEventListener   (Event.ENTER_FRAME, onFrame);
            }
        }

        private function onKey (e :KeyboardEvent) : void
        {
            switch (e.keyCode)
            {
                case 32 : onUpload ();
                    break;
                    //
                case 65 : filter = FILTER.identity ();
                    break;
                case 90 : filter = FILTER.contrast (75);
                    break;
                case 69 : filter = FILTER.emboss ();
                    break;
                case 82 : filter = FILTER.negative (190);
                    break;
                case 84 : filter = FILTER.saturation (75);
                    break;
                case 89 : filter = FILTER.outline ();
                    break;
            }
        }

        private function onClick (e : MouseEvent) : void
        {
            pn_inv = ! pn_inv;
        }

        private function onFrame (e : Event) : void
        {
            if (! sChan)
            {
                sChan = new SoundChannel();
                sChan = sound.play (0, 50);

                infos.htmlText = sTags;
                gLoad.visible = true;
            }

            lPeak = sChan.leftPeak;
            rPeak = sChan.rightPeak;

            lChan.draw (lPeak * 65, 0xFFFFFF);
            rChan.draw (rPeak * 65, 0xFFFFFF);

            pn_val.x += (pn_inv ? -lPeak : lPeak) * 7.5;
            pn_val.y += (pn_inv ? -rPeak : rPeak) * 7.5;

            plays.htmlText = '<font size=\'10\' color=\'#FFFFFF\'>[ ' + onDuration (sChan.position) + ' | ' + onDuration (sound.length) + ' ]</font>';

            //

            onRender ();
        }

        private function onRender () : void
        {
            pixel.lock ();

            // --o MODEL

            model.perlinNoise
            (
                pn_bsX, pn_bsY, 1, pn_rsd, true,
                false,  7, false, [pn_val]
            );

            model.draw (model, null, null, bdM_01);
            model.draw (model, null, null, bdM_02);

            // --o ADDITIONAL FILTER

            if (filter != FILTER.identity ())
            {
                model.applyFilter
                (
                    model, model.rect, new Point (0, 0), filter
                );    
            }

            // --o COMPOSITE

            pixel.draw (model, mat_01);
            pixel.draw (model, mat_02);

            pixel.draw (model, mat_03);
            pixel.draw (model, mat_04);

            pixel.draw (model, mat_05);
            pixel.draw (model, mat_06);

            pixel.draw (model, mat_07);
            pixel.draw (model, mat_08);

            //

            pixel.unlock ();
        }

        // --o SOUND EVENT HANDLERS

        private function onID3 (e : Event) : void
        {   
            sound.removeEventListener (Event.ID3, onID3);

            sTags = '<font size=\'10\' color=\'#FFFFFF\'>[ ';

            if (sound.id3.TPE1) sTags += sound.id3.TPE1;
            if (sound.id3.TIT2) sTags += ' | ' + sound.id3.TIT2;
            if (sound.id3.TALB) sTags += ' | ' + sound.id3.TALB;
            if (sound.id3.TBPM) sTags += ' | ' + sound.id3.TBPM + ' BPM';

            sTags += ' ]</font>';
        }

        private function onDuration (n : uint) : String
        {
            var m : uint = Math.floor(n / 1000 / 60);
            var s : uint = Math.floor(n / 1000) % 60;

            return m + ':' + (s < 10 ? '0' + s : s);
        }

        private function onOpen (e : Event) : void {}

        private function onProgress (e : ProgressEvent) : void
        {
            var ratio : Number = 1 - e.bytesLoaded / e.bytesTotal;

            gLoad.draw (gLoad.w * ratio, 0xFFFFFF);
        }

        private function onComplete (e : Event) : void {}

        private function onIOError (e : IOErrorEvent) : void {}

        private function onSecurityError (e : SecurityErrorEvent) : void { }

        // FILE UPLOAD

        private function onUpload () : void
        {
            sLoad =  new FileReference ();

            sLoad.addEventListener
            (
                Event.SELECT, onFileSelect
            );

            sLoad.addEventListener
            (
                Event.COMPLETE, onFileComplete
            );

            sLoad.addEventListener
            (
                ProgressEvent.PROGRESS, onProgress
            );

            sLoad.browse
            (
                [new FileFilter ('Music File (*.mp3)', '*.mp3;')]
            );
        }

        private function onFileSelect (e : Event) : void
        {
            if (sound.hasEventListener (ProgressEvent.PROGRESS))
            {
                sound.removeEventListener
                (
                    ProgressEvent.PROGRESS, onProgress
                );
            }

            sLoad.load ();
        }

        private function onFileComplete (e : Event) : void
        {
            var mp3File : MP3FILE = new MP3FILE (sLoad.data);

            mp3File.addEventListener (MP3FILE.AVAILABLE, onFileAvailable);
        }

        private function onFileAvailable (e : Event) : void
        {
            sound = e.target.sound;

            sTags = '<font size=\'10\' color=\'#FFFFFF\'>[ ' + sLoad.name.slice(0,sLoad.name.lastIndexOf('.')) + ' ]';

            if (sChan)
            {
                sChan.stop ();
   
                sChan = sound.play (0, 50);

                infos.htmlText = sTags;
            }
        }
    }
}

//

import flash.geom.Matrix;

import flash.display.Shape;
import flash.display.GraphicsPath;
import flash.display.IGraphicsData;
import flash.display.GraphicsStroke;
import flash.display.GraphicsGradientFill;

/**
*    @author SPANVEGA // CHRISTIAN //
**/

internal class GRAPHIC_BAR extends Shape
{
    public var c : uint;
    public var m : Matrix;
    public var w : Number;
    public var h : Number;    

    private var g_p : GraphicsPath;
    private var g_s : GraphicsStroke;
    private var g_f : GraphicsGradientFill;

    private var g_c : Vector.<int> = new Vector.<int>();
    private var g_d : Vector.<Number> = new Vector.<Number>();
    private var g_v : Vector.<IGraphicsData> = new Vector.<IGraphicsData>();

    public function GRAPHIC_BAR (x : Number, y : Number, width : Number, height : Number, display : String = 'H' /* || 'V' */)
    {
        this.x = x;
        this.y = y;

        w =  width;
        h = height;

        m = new Matrix ();
        m.createGradientBox (2, 2);

        if (display == 'V') rotation = -90;

        //

        g_s = new GraphicsStroke (h);

        g_f = new GraphicsGradientFill
        (
            'linear', [c, 0], [1, 0], [64, 128], m, 'repeat'
        );
        g_s.fill = g_f;

        g_c.push (1, 2);

        g_p = new GraphicsPath (g_c, g_d);
    }

    public function draw (value : Number, color : uint) : void
    {
        clear ();

        g_f.colors = [c=color, 0];

        g_d.length = 0;
        g_d.push (0, 0, value, 0);

        g_p.data = g_d;

        g_v.length = 0;
        g_v.push (g_s, g_p);

        graphics.drawGraphicsData (g_v);
    }

    public function clear () : void
    {
        graphics.clear ();
    }

    public function reset () : void
    {
        draw (w, c);
    }
}

//

import flash.filters.ConvolutionFilter;
import flash.filters.ColorMatrixFilter;

/**
*    @author SPANVEGA // CHRISTIAN //
**/

internal class FILTER
{
    /** 
    *    RGB LUMINANCE CONSTANTS
    *    http://www.faqs.org/faqs/graphics/colorspace-faq/
    **/
    
    private static const R : Number = 0.212671;
    private static const G : Number = 0.715160;
    private static const B : Number = 0.072169;

    // --o COLORMATRIX BASED FILTERS
    // _____________________________


    // --o ALPHA RANGE [ 0 | 100 ]

    public static function alpha (n : uint = 100) : ColorMatrixFilter
    {
        var a : Number = n / 100;

        return new ColorMatrixFilter
        (
            [
                1, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, a, 0
            ]
        );
    }

    public static function blue () : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                0, 0, 0, 0, 0,
                0, 0, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, 1, 0
            ]
        );
    }

    // --o BRIGHTNESS RANGE [ -255 | 255 ]

    public static function brightness (n : Number = 255) : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                1, 0, 0, 0, n,
                0, 1, 0, 0, n,
                0, 0, 1, 0, n,
                0, 0, 0, 1, 0
            ]
        );
    }

    // --o CONTRAST RANGE [ -100 | 100 ]

    public static function contrast (n : Number = 100) : ColorMatrixFilter
    {
        var c : Number = n / 100;

        var m : Number = 1 + ((n > 0) ? 4 * c : c);

        var f : Number = (-128 * c) * ((n > 0) ? 5 : 1);

        return new ColorMatrixFilter
        (
            [
                m, 0, 0, 0, f,
                0, m, 0, 0, f,
                0, 0, m, 0, f,
                0, 0, 0, 1, 0
            ]
        );
    }

    public static function green () : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                0, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 0, 0, 0,
                0, 0, 0, 1, 0
            ]
        );
    }

    // --o HUE RANGE [ -180 | 180 ]

    public static function hue (n : Number = 180) : ColorMatrixFilter
    {        
        var c : Number = Math.cos (n * Math.PI / 180);
        var s : Number = Math.sin (n * Math.PI / 180);
    
        return new ColorMatrixFilter
        (
            [
                R + (c*(1-R))+ (s*(-R)),     G + (c*(-G)) + (s*(-G)),  B + (c*(-B)) + (s*(1-B)),    0, 0,
                R + (c*(-R)) + (s*0.143),    G + (c*(1-G))+ (s*0.140), B + (c*(-B)) + (s*(-0.283)), 0, 0,
                R + (c*(-R)) + (s*(-(1-R))), G + (c*(-G)) + (s*G),     B + (c*(1-B))+ (s*B),        0, 0,
                0,                           0,                        0,                           1, 0
            ]
        );
    }

    public static function identity () : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                1, 0, 0, 0, 0, 
                0, 1, 0, 0, 0, 
                0, 0, 1, 0, 0, 
                0, 0, 0, 1, 0
            ]
        );
    }

    // --o NEGATIVE RANGE [ 0 | 255 ]

    public static function negative (n : Number = 255) : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
               -1, 0, 0, 0, n,
                0,-1, 0, 0, n,
                0, 0,-1, 0, n,
                0, 0, 0, 1, 0
            ]
        );
    }

    public static function red () : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                1, 0, 0, 0, 0,
                0, 0, 0, 0, 0,
                0, 0, 0, 0, 0,
                0, 0, 0, 1, 0
            ]
        );
    }

    // --o SATURATION RANGE [ -100 | 100 ]

    public static function saturation (n : Number = 100) : ColorMatrixFilter
    {
        var s : Number = 1 + ((n > 0) ? 3 * (n / 100) : (n / 100));

        var base : Number = 1 - s;

        var rb : Number = base*R;
        var rs : Number = rb + s;

        var gb : Number = base*G;
        var gs : Number = gb + s;

        var bb : Number = base*B;
        var bs : Number = bb + s;

        return new ColorMatrixFilter
        (
            [
                rs, gb, bb, 0, 0,
                rb, gs, bb, 0, 0,
                rb, gb, bs, 0, 0,
                 0,  0,  0, 1, 0
            ]
        );
    }

    public static function sepia () : ColorMatrixFilter
    {
        return new ColorMatrixFilter
        (
            [
                0.393, 0.769, 0.189, 0, 0,
                0.349, 0.686, 0.168, 0, 0, 
                0.272, 0.534, 0.131, 0, 0,
                0,     0,     0,     1, 0
            ]
        );
    }

    public static function tint (n : uint) : ColorMatrixFilter
    {
        var r : uint = n >> 16;
 
        var g : uint = n - (r << 16) >> 8;

        var b : uint = n - (r << 16) - (g << 8);

        return new ColorMatrixFilter
        (
            [
                r/255, 0, 0, 0, 0,
                0, g/255, 0, 0, 0,
                0, 0, b/255, 0, 0,
                0, 0,     0, 1, 0
            ]
        );
    }

    // --o CONVOLUTION BASED FILTERS
    // _____________________________

    public static function blur () : ConvolutionFilter
    {
        var a : Array =
        [
            0, 1, 0,
            1, 1, 1,
            0, 1, 0
        ];
 
        return new ConvolutionFilter
        (
            3, 3, a, 5, 0
        );
    }

    public static function edge () : ConvolutionFilter
    {
        var a : Array =
        [
            0,-1, 0,
           -1, 4,-1,
            0,-1, 0
        ];

        return new ConvolutionFilter
        (
            3, 3, a, 1, 0
        );
    }

    public static function emboss () : ConvolutionFilter
    {
        var a : Array =
        [
           -2,-1, 0,
           -1, 1, 1,
            0, 1, 2
        ];
 
        return new ConvolutionFilter
        (
            3, 3, a, 1, 0
        );
    }

    public static function enhance () : ConvolutionFilter
    {
        var a : Array =
        [
            0, -2, 0,
           -2, 20,-2,
            0, -2, 0
        ];
 
        return new ConvolutionFilter
        (
            3, 3, a, 10, -40
        );
    }

    public static function outline () : ConvolutionFilter
    {
        var a : Array =
        [
            -30, 30, 0,
            -30, 30, 0,
            -30, 30, 0
        ];
 
        return new ConvolutionFilter
        (
            3, 3, a, 9, 0
        );
    }

    public static function sharpen () : ConvolutionFilter
    {
        var a : Array =
        [
            0,-1, 0,
           -1, 5,-1,
            0,-1, 0
        ];

        return new ConvolutionFilter
        (
            3, 3, a, 1, 0
        );
    }
}

//

import mx.utils.Base64Decoder;

import flash.media.Sound;
import flash.utils.ByteArray;

import flash.display.Loader;
import flash.display.LoaderInfo;

import flash.events.Event;
import flash.events.EventDispatcher;

import com.codeazur.as3swf.SWF;
import com.codeazur.as3swf.SWFData;
    
import com.codeazur.as3swf.data.SWFScene;
import com.codeazur.as3swf.data.SWFSymbol;
import com.codeazur.as3swf.data.consts.SoundRate;
import com.codeazur.as3swf.data.consts.SoundSize;
import com.codeazur.as3swf.data.consts.SoundType;
import com.codeazur.as3swf.data.consts.SoundCompression;

import com.codeazur.as3swf.tags.TagEnd;
import com.codeazur.as3swf.tags.TagDoABC;
import com.codeazur.as3swf.tags.TagShowFrame;
import com.codeazur.as3swf.tags.TagSymbolClass;
import com.codeazur.as3swf.tags.TagDefineSound;
import com.codeazur.as3swf.tags.TagFileAttributes;
import com.codeazur.as3swf.tags.TagSetBackgroundColor;
import com.codeazur.as3swf.tags.TagDefineSceneAndFrameLabelData;

/**
* MP3FILE CLASS DERIVED FROM
* http://code.google.com/p/makc/source/browse/trunk/flash/fp10_fft/ClientMP3Loader.as
* 
* FURTHER INFORMATIONS AVAILABLE @
* http://wiki.github.com/claus/as3swf/play-mp3-directly-from-bytearray
* http://github.com/claus/as3swf/raw/master/bin/as3swf.swc
*/

internal class MP3FILE extends EventDispatcher
{
    public var sound : Sound;
    
    /** Dispatch MP3FILE.AVAILABLE Event **/

    static public const AVAILABLE : String = 'AVAILABLE';


    public function MP3FILE (b : ByteArray)
    {
        var swf : ByteArray = createSWFFromMP3 (b);

        var loader : Loader = new Loader();

        loader.contentLoaderInfo.addEventListener
        (
            Event.INIT, initHandler
        );
        loader.loadBytes(swf);    
    }

    private function initHandler(e:Event):void
    {
        var SoundClass : Class = LoaderInfo(e.currentTarget).applicationDomain.getDefinition('MP3Wrapper_soundClass') as Class;

        sound = new SoundClass() as Sound;

        dispatchEvent (new Event (MP3FILE.AVAILABLE));
    }

    private function createSWFFromMP3 (mp3 : ByteArray) : ByteArray
    {
        var swf : SWF = new SWF ();
        swf.tags.push (new TagFileAttributes());
        swf.tags.push (new TagSetBackgroundColor());

        var defineSceneAndFrameLabelData : TagDefineSceneAndFrameLabelData = new TagDefineSceneAndFrameLabelData ();
        defineSceneAndFrameLabelData.scenes.push (new SWFScene (0, 'Scene 1'));
        swf.tags.push (defineSceneAndFrameLabelData);
        swf.tags.push (TagDefineSound.createWithMP3(1, mp3));
        swf.tags.push (TagDoABC.create(abc));

        var symbolClass : TagSymbolClass = new TagSymbolClass ();
        symbolClass.symbols.push(SWFSymbol.create(1, 'MP3Wrapper_soundClass'));
        symbolClass.symbols.push(SWFSymbol.create(0, 'MP3Wrapper'));
        swf.tags.push(symbolClass);
        swf.tags.push(new TagShowFrame());
        swf.tags.push(new TagEnd());

        var swfData:SWFData = new SWFData();
        swf.publish(swfData);

        return swfData;
    }

    private static function abcDataToByteArray () : ByteArray
    {
        var decoder : Base64Decoder = new Base64Decoder ();

        decoder.decode (<![CDATA[
            nVBNb9NAEJ1Z77eT5qNtGoQiIXFDKFlRiUNvqC0oBygiEuQCtZtssVHiRLZpwr/MT2IcFyKujEf2
            +s17b57dhiFQPVHL7XC2yr0dv1347Zui8KWdrH5m8/0xvF/ERTJc+nkaiz3cfeRfHEhw+v7j+Zc8
            Xq99fltU8CWpCntAm7XNPC3Wi/iXnKzztPT2QBX7+4ukLNcXo9FmsxnG89Wdp0XL0SvnXo/uKdto
            uR2lWenzLF6oz9efJuObD3JS5mn2XZ0PXXWFy+3tH4q8ufvhZ2WjXu0ffFYWrevqcUUx4nKWUK6r
            OlFN7YwraTwr0wdfI71/5perrIzTzOe2hz3elz3V1z3bN/qodxIgIj9RyBQGignDUHGtuFEyVLyh
            eFPpluJthV0T0OhYmVOjmSIPeaZkvwn/UxxBAAMWkCcXIJgRoEEqoyBEDWAAiWMlhh1UYImMDQmg
            NaXlABIZBzQoOLAGSo5BA+gzWLBz74CkGARIh4ARZnfuK382haRCOEMhzc59sy87iSVAIEold243
            BnqTJBBnJGhGRy5quSignuJgMEgYjVVFrndoRKX/6uinoXxKuvZBx6inbFBpBVEsoja1NmRobEja
            SCS6NmiQgX6+cx4eDTou6rro2EWKehoM9pVIov4G
        ]]>);

        var decodedBytes : ByteArray = decoder.toByteArray ();

        decodedBytes.inflate ();

        return decodedBytes;
    }

    private static var abc : ByteArray = abcDataToByteArray ();
}