/**
 * Copyright baudon.thomas ( http://wonderfl.net/user/baudon.thomas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qPeW
 */

package 
{
    import flash.ui.Mouse;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class Main extends Sprite 
    {
        
        private var mSquare:Shape;
        private var mSelectection:Shape;
        private var mIsoTransform:Matrix;
        
        public function Main():void 
        {
           
            mSquare = new Shape();
            
            mSquare.graphics.lineStyle(3, 0x333366, 0.8);
            for (var i:uint = 0; i < 20; ++i) {
                for (var j:int = 0; j < 20; ++j) {
                    if ((i+j)%2 > 0) 
                        mSquare.graphics.beginFill(0x666699);
                    else 
                        mSquare.graphics.beginFill(0x9999cc);
                    
                    mSquare.graphics.drawRect(j*32, i*32, 32, 32);
                    mSquare.graphics.endFill();
                }
            }            
            
            addChild(mSquare);
            
          
            
            mIsoTransform = new Matrix();
            mIsoTransform.rotate(Math.PI / 4);
            mIsoTransform.scale(1, 0.5);
            mIsoTransform.translate(stage.stageWidth / 2, 0);
            
            mSquare.transform.matrix = mIsoTransform;
            
            mIsoTransform.invert();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove, false, 0, true);
        }
        
        private function mouseMove(e:MouseEvent):void
        {
            var mousePos:Point = new Point(mouseX, mouseY);
            
            mousePos = mIsoTransform.transformPoint(mousePos);
            
            var x:int = mousePos.x / 32;
            var y:int = mousePos.y / 32;
            
            var transform:Matrix = new Matrix();
            transform.translate(x * 32, y * 32);
            transform.rotate(Math.PI / 4);
            transform.scale(1, 0.5);
            transform.translate(stage.stageWidth / 2, 0);
            mSelectection.transform.matrix = transform;
        }        
    }
}