/**
 * Copyright PESakaTFM ( http://wonderfl.net/user/PESakaTFM )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qPbj
 */

// forked from chimanaco's particle1
/**
*  
*  wonderfl内の色んなparticle作品を参考にさせて頂いています。
*  何せどれもレベルが高いのでダウングレードしつつ勉強。
*
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    import com.flashdynamix.utils.SWFProfiler;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "000000")]
    public class Main extends Sprite
    {
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        private static const NUM_PARTICLES:uint = 20000;
        private static const NUM_PARTICLE_ONCE:uint = 1;
        private static const CTF:ColorTransform = new ColorTransform(0.9, 0.9, 0.9, 1, -100, -20, 0);
        private var _canvas:BitmapData;
        private var _particles:Array = new Array(); 
         
        /**
         * コンストラクタ
         *
         * @access public
         * @param
         * @return
         */
        public function Main()
        {
            init();
        }
        
        /**
         * init
         *
         * @access private
         * @param
         * @return void
         */
        private function init():void
        {
            // BitmapData作成
            _canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
            addChild(new Bitmap(_canvas, PixelSnapping.NEVER, false));
            
           // SWFProfiler
           SWFProfiler.init( this );
            
            // ENTER_FRAMEイベント
            addEventListener(Event.ENTER_FRAME, enterFrameHandler)
        }
        
        /**
         * init
         *
         * @access private
         * @param e ENTER_FRAMEイベント
         * @return void
         */
        private function enterFrameHandler(e:Event):void
        {
            // bitmapイメージの変更をロック
            _canvas.lock();
            // bitmapイメージの色を変換
            _canvas.colorTransform(_canvas.rect, CTF);
            
            // particleを生成
            for (var i:int = 0; i < NUM_PARTICLE_ONCE; i++) {
                createParticle();
            };
            
            // particleの個数が一定量越えたら古いものから配列から削除
            while (_particles.length > NUM_PARTICLES)
            {
                var p:Particle = _particles.shift();
                p = null;
            }
            
            var len:int = _particles.length;
            for (var j:int = 0; j < len; j++) {            
                var pos:Point= _particles[j].p;
                
                // particleをupdate
                _particles[j].update();
                
                // bitmap上のparticleの座標を指定した色で描画
                _canvas.setPixel(pos.x >> 0, pos.y >> 0, 0xFFFFFF);
            }
            
            // 処理が終わったのでbitmapイメージの変更のロックを解除
            _canvas.unlock();

  
        }
        
        /**
         * particleを作る
         *
         * @access private
         * @param
         * @return void
         */
        private function createParticle():void
        {
            var radian:Number = Math.random() * Math.PI * 2;
            var dx:Number = Math.cos(radian);
            var dy:Number = Math.sin(radian);
            
            // particle
            var p:Particle = new Particle();
            p.p.x = WIDTH / 2;
            p.p.y = HEIGHT / 2;
            
            //配列に追加
            _particles.push(p);
            
            // 移動距離を設定
            p.dx = dx;
            p.dy = dy;
        }
    }
}

import flash.geom.Point;
internal class Particle
{
    public var p:Point = new Point();
    public var dx:Number;
    public var dy:Number;
    
    /**
     * update
     *
     * @access public
     * @param
     * @return void
     */
    public function update():void
    {        
        p.x += dx * Math.random() * 5;
        p.y += dy * Math.random() * 5;
    }
    
}