/**
 * Copyright rainafter ( http://wonderfl.net/user/rainafter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qPA7
 */

// forked from Test_Dept's Legacy Display
package {

	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * LegacyDisplay
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#cccccc", width="465", height="465", frameRate="12")]
	public class LegacyDisplay extends Sprite {

		public function LegacyDisplay() {

			var color : uint = 0xff0000;
			var hiColor : uint = color;
			var loColor : uint = getDarkColor(hiColor, 0.25);

			var patterns1 : Array = [
				"a", "b", "g", "e", "d", "c", "g", "f", "a",
				"p",
				"abcdefg.", ""
			];
			var index1 : int = 0;
			
			var patterns2 : Array = [
				"abcdef", "bc",     "abdeg", "abcdg",   "bcfg",
				"acdfg",  "acdefg", "abc",   "abcdefg", "abcdfg"
			];
			var index2 : int = 0;

			addEventListener(Event.ENTER_FRAME, function(event : Event) : void {

				var g : Graphics = graphics;
				g.clear();

				var pattern1 : String = patterns1[index1];
		        index1 = (index1 + 1) % patterns1.length;
				var pattern2 : String = patterns2[index2];
		        index2 = (index2 + 1) % patterns2.length;

		        LEDUtil.draw7Segments(g, pattern1, 10, 10, 
		        	200, 0, hiColor, loColor, 0x000000); 
		        LEDUtil.draw7Segments(g, pattern2, 215, 10,
		        	200, 0, hiColor, loColor, 0x000000); 
			} );
		}

	    private static function getDarkColor(color : uint, scale : Number) : uint {
	        var r : uint = (color >>> 16) & 0xff;
	        var g : uint = (color >>> 8) & 0xff;
	        var b : uint = color & 0xff;
	        r = (r * scale) & 0xff;
	        g = (g * scale) & 0xff;
	        b = (b * scale) & 0xff;
	        return (r << 16) | (g << 8) | b;
	    }
  	}
}

import flash.display.Graphics;

/*

[Segments]

     a
    f b
     g
    e c
     d
       p

[Digit Patterns]

0: abcdef
1: bc
2: abdeg
3: abcdg
4: bcfg
5: acdfg
6: acdefg
7: abc
8: abcdefg
9: abcdfg
-: g

*/
class LEDUtil {

    public static function draw7Segments(
        g : Graphics,
        pattern : String,
        x : Number,
        y : Number,
        width : Number,
        height : Number,
        hiColor : uint,
        loColor : uint,
        bgColor : uint
    ) : void {

		// auto size
		if (width <= 0) {
			width = height * 7 / 10;
		} else if (height <= 0) {
			height = width *10 / 7;
		}

        g.beginFill(bgColor);
        g.drawRect(x, y, width, height);
        g.endFill();

        var scale : Number = (width / height > _SEG_WIDTH / _SEG_HEIGHT)?
            height / _SEG_HEIGHT : width / _SEG_WIDTH;

        var cx : Number = x + (width - _SEG_WIDTH * scale) / 2;
        var cy : Number = y + (height - _SEG_HEIGHT * scale) / 2;
        
        var on : Boolean;
        
        for (var i : int = 0; i < _ALL_SEGMENTS.length; i++) {
            var c : String = _ALL_SEGMENTS.charAt(i);
            on = (pattern != null && pattern.indexOf(c) != -1);
            drawSegment(g, c, cx, cy, scale, on? hiColor: loColor);
        }

        on = (pattern != null && pattern.indexOf(".") != -1);
        drawPoint(g, cx, cy, scale, on? hiColor : loColor);
    }

    private static function drawSegment(
    		g : Graphics,
    		segment : String,
    		x : Number,
    		y : Number,
    		scale : Number,
    		color : uint
    ) : void {

        var data : Array = _segmentData[segment];

        g.beginFill(color);

        for (var i : int = 0; i < data.length; i++) {

            var dx : Number = data[i].x * scale + x;
            var dy : Number = data[i].y * scale + y;

            if (i == 0) {
                g.moveTo(dx, dy);
            } else {
                g.lineTo(dx, dy);
            }
        }

        g.endFill();
    }
    
    private static function drawPoint(
    		g : Graphics, 
    		x : Number,
    		y : Number,
    		scale : Number,
    		color : uint
    ) : void {
        g.beginFill(color);
        g.drawCircle(542 * scale + x, 840 * scale + y, 46 * scale);
        g.endFill();
    }

    private static const _SEG_WIDTH : Number = 636;

    private static const _SEG_HEIGHT : Number = 1000;

    private static const _ALL_SEGMENTS : String = "abcdefg";
    
    private static const _segmentData : Object = {
        a : [
            {x : 212, y : 122},
            {x : 194, y : 138},
            {x : 252, y : 208},
            {x : 496, y : 208},
            {x : 576, y : 138},
            {x : 560, y : 122}
        ],
        b : [
            {x : 580, y : 144},
            {x : 498, y : 218},
            {x : 460, y : 460},
            {x : 494, y : 496},
            {x : 544, y : 454},
            {x : 598, y : 166}
        ],
        c : [
            {x : 490, y : 518},
            {x : 442, y : 554},
            {x : 398, y : 792},
            {x : 454, y : 842},
            {x : 478, y : 842},
            {x : 526, y : 554}
        ],
        
        d : [
            {x : 138, y : 802},
            {x : 72,  y : 852},
            {x : 82,  y : 888},
            {x : 424, y : 888},
            {x : 446, y : 868},
            {x : 450, y : 852},
            {x : 398, y : 802}
        ],
        e : [
            {x : 144, y : 516},
            {x : 94,  y : 560},
            {x : 46,  y : 842},
            {x : 58,  y : 842},
            {x : 140, y : 784},
            {x : 176, y : 554}
        ],
        f : [
            {x : 184, y : 146},
            {x : 164, y : 164},
            {x : 108, y : 460},
            {x : 148, y : 498},
            {x : 198, y : 458},
            {x : 236, y : 208}
        ],
        g : [
            {x : 204, y : 462},
            {x : 156, y : 508},
            {x : 190, y : 554},
            {x : 432, y : 554},
            {x : 486, y : 504},
            {x : 454, y : 462}
        ]    
    };      
}    
