/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qORX
 */

// forked from saintw's particle test
package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class Main extends Sprite {
            
        private var display:BitmapDisplay;
            
        public function Main() {
            
            display = new BitmapDisplay(465, 465);
            this.addChild(display);
            display.startRender();
            
        }
    }
    

}


import flash.utils.Timer;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.geom.ColorTransform;
    
class BitmapDisplay extends Sprite {
    
    private var _bmp:Bitmap;
    private var _bmd:BitmapData;
    private var _lastParticle:Particle2D;
    private var _transform:ColorTransform;
    
    public function BitmapDisplay(width:Number, height:Number) {
        _bmd = new BitmapData(width, height, true, 0);
        _bmp = new Bitmap(_bmd, "auto", true);
        this.addChild(_bmp);
        _transform = new ColorTransform(1.01, 1.01, 1.01, 0.92);
    }
    
    public function startRender():void {
        this.addEventListener(Event.ENTER_FRAME, update);
        var timer:Timer = new Timer(600);
        timer.addEventListener(TimerEvent.TIMER, repeate);
        timer.start();
    }
    
    private function repeate(event:TimerEvent):void {
        explode(200, 200);
    }
    
    private function append(curr:Particle2D):void {
        if (_lastParticle == null)
        {
            _lastParticle = curr;
        }else {
            _lastParticle.next = curr;
            curr.prev = _lastParticle;
            _lastParticle = curr;
        }
    }
    
    private function remove(curr:Particle2D):void {
        
        if (_lastParticle == curr) {
            _lastParticle = curr.prev;
        }else {
            if (curr.prev) {
                curr.prev.next = curr.next;
            }
            if (curr.next) {
                curr.next.prev = curr.prev;
            }
        }
    }
    
    private function update(event:Event):void {
        _bmd.lock();
        
        _bmd.colorTransform(_bmd.rect, _transform);
        var tmpPar:Particle2D = _lastParticle;
        while(tmpPar) {
            tmpPar.update();
            if (tmpPar.life < 0) {
                remove(tmpPar);
            }else {
                _bmd.setPixel32(tmpPar.x, tmpPar.y, tmpPar.color);
            }
            tmpPar = tmpPar.prev;
        }
        
        _bmd.unlock();
    }
    
    private function explode(x:Number, y:Number):void {
        var tmpdot:Particle2D;
        var firc:Number = 0.9;
        var parNum:int = 1000;
        for (var i:int = parNum; i >= 0; i-- ) {
            tmpdot = new Particle2D(x, y, Math.random() * 6.282, Math.random() * 10, firc);
            append(tmpdot);
        }
    }
    
    
}

class Particle2D {
    
    public var x:Number;
    public var y:Number;
    private var _vx:Number;
    private var _vy:Number;
    private var _friction:Number;
    public var color:uint;
    public var prev:Particle2D;
    public var next:Particle2D;
    public var life:int;
    
    public function Particle2D(px:Number, py:Number, angle:Number, force:Number, friction:Number) {
        x = px;
        y = py;
        _friction = friction;
        _vx = Math.cos(angle) * force;
        _vy = Math.sin(angle) * force;
        life = 60;
        color = 0xffffff00;
    }
        
    public function update():void {
        life--;
        _vx *= _friction;
        _vy *= _friction;
        x += _vx;
        y += _vy;
    }
    
}