/**
 * Copyright Zahurdias.Calimero ( http://wonderfl.net/user/Zahurdias.Calimero )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qMu2
 */

package
{
    import flash.display.DisplayObject;
    import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.*;
    
    [SWF(width="1200", height="630", frameRate="60", backgroundColor="#FFFFFF")]
    public class FlashChartingTest extends Sprite
    {
        public function FlashChartingTest(){
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            this.mouseEnabled = false;

            createChildren();
            init();
        }
        
        private var meter:FPSMeter;
        private var fps:TextField;
        private var results:TextField;
        private var draw:Graphics;
        
        private var chartWidth:Number = 1200;
        private var chartHeight:Number = 600;
        private var highestStock:Number = 200;
        private var totalMinutes:Number = 480;
        private var chartXSpread:Number;
        private var chartYSpread:Number;
        private var a:Array = new Array();
        private var b:Array = new Array();
        private var c:Array = new Array();
        private var d:Array = new Array();
        private var e:Array = new Array();
        
        protected function init():void{
            chartXSpread = chartWidth/totalMinutes;
            chartYSpread = chartHeight/highestStock;
            meter = new FPSMeter();
            addEventListener(Event.ENTER_FRAME, processFrame);
        }
        protected function processFrame(evt:Event):void{
            //create background
            draw.clear();
            draw.lineStyle(0, 0x666666);
            //draw.lineStyle(0, 0.6);
            var xCoord:Number;
            var yCoord:Number;
            for(var x:Number=0; x<=totalMinutes; x+=40){
                xCoord = x*chartXSpread;
                draw.moveTo(xCoord, 0);
                draw.lineTo(xCoord, chartHeight);
            }
            for(var y:Number=0; y<=highestStock; y+=20){
                yCoord = y*chartYSpread;
                draw.moveTo(0, yCoord);
                draw.lineTo(chartWidth, yCoord);
            }
            //add data
            fillStockData(a, 180);
            fillStockData(b, 140);
            fillStockData(c, 100);
            fillStockData(d, 60);
            fillStockData(e, 20);
            graphStockData(a, b, 0xFF00FF, 0xFFAAFF);
            graphStockData(b, c, 0xFF0000, 0xFFAAAA);
            graphStockData(c, d, 0xFF6600, 0xFFCCAA);
            graphStockData(d, e, 0x0000FF, 0xAAAAFF);
            graphStockData(e, null, 0x00FF00, 0xAAFFAA);
            
            updatePerformance();
        }
        
        protected function fillStockData(data:Array, region:Number):void {
            var diff:Number = 15;
            var low:Number = region-(diff/2);
            var i:int = 0;
            var stock:StockVO;
            
            if(data.length == 0){
                while(i <= totalMinutes){
                    stock = new StockVO(i, Math.random()*diff+low);
                    data.push(stock);
                    i++;
                }
            }else{
                while(i <= totalMinutes){
                    stock = data[i];
                    stock.minute--;
                    i++;
                }
                stock = data.shift();
                stock.minute = totalMinutes;
                stock.value = Math.random()*diff+low;
                data.push(stock);
            }
        }
        
        protected function graphStockData(topData:Array, bottomData:Array, line:uint, fill:uint):void{
            var stock:StockVO;
            var xCoord:Number;
            var yCoord:Number;
            var i:int = 0;
            
            //draw.lineStyle(2, line, 1.0, false, "normal", CapsStyle.ROUND, JointStyle.ROUND);
            draw.lineStyle(0, line, 1.0, false, "none", CapsStyle.NONE, JointStyle.ROUND);
            //draw.lineStyle();
            //draw.lineStyle(0,line);
            draw.beginFill(fill, 0.6);
            //draw.beginFill(fill);
            
            //plot begin point
            stock = topData[i];
            xCoord = stock.minute*chartXSpread;
            yCoord = chartHeight-stock.value*chartYSpread;
            draw.moveTo(xCoord, yCoord);
            
            //plot data points
            while(++i < topData.length){
                stock = topData[i];
                xCoord = stock.minute*chartXSpread;
                yCoord = chartHeight-stock.value*chartYSpread;
                draw.lineTo(xCoord, yCoord);
            }
            draw.lineStyle();
            //draw.lineStyle(2, line, 0, false, "none", CapsStyle.NONE, JointStyle.ROUND);
            
            if(bottomData != null){
                //clamp fill to chart lines below
                i = bottomData.length;
                while(--i > -1){
                    stock = bottomData[i];
                    xCoord = stock.minute*chartXSpread;
                    yCoord = chartHeight-stock.value*chartYSpread;
                    draw.lineTo(xCoord, yCoord);
                }
            }else{
                //clamp fill to bottom of chart
                draw.lineTo(chartWidth, chartHeight);
                draw.lineTo(0, chartHeight);
            }
            //draw.endFill();
        }
        
        protected function updatePerformance():void {
            meter.increment();
            fps.text = meter.getFramerate()+" fps";
            if(testRunning){
                continueTest();
            }
        }
        
        private var testBegin:int = 0;
        private var testData:Array = [];
        private var testRunning:Boolean = false;
        private function startTest(evt:MouseEvent):void{
            testBegin = getTimer();
            testRunning = true;
            testData = [];
            results.text = "Running..."
        }
        private function continueTest():void{
            var time:uint = getTimer();
            testData.push(time);
            if(time-testBegin > 10000){
                testRunning = false;
                var output:Number = testData.length/(time-testBegin)*1000;
                results.text = "Test Average: "+FPSMeter.formatNumber(output)+" fps";
            }
        }
        
        private function createChildren():void {
            var header:Sprite = new Sprite(); header.graphics.beginFill(0xC0C4DF); header.graphics.drawRect(0,0,1200,30); addChild(header);
            var title:TextField = createTextField("GUIMark"); title.width = 300; title.x = 4; header.addChild(title);
            var button:Sprite = createButton(); button.x = 320; button.y = 7; button.addEventListener(MouseEvent.CLICK, startTest); header.addChild(button);
            fps = createTextField(""); fps.width = 140; fps.x = 150; header.addChild(fps);
            results = createTextField(""); results.width = 300; results.x = 555; header.addChild(results);
            var canvas:Sprite = new Sprite(); canvas.x = 0; canvas.y = 30; addChild(canvas);
            canvas.mouseEnabled=false;
            draw = canvas.graphics;
        }
        private function createTextField(val:String):TextField {
            var txt:TextField = new TextField();
            txt.y = 6;
            txt.defaultTextFormat = new TextFormat("Arial", 15, 0x000000, true);
            txt.text = val;
            return txt;
        }
        private function createButton():Sprite {
            var buttonText:TextField = new TextField();
            buttonText.x = 7;
            buttonText.y = 1;
            buttonText.width = 63;
            buttonText.height = 18;
            buttonText.defaultTextFormat = new TextFormat("Arial", 12, 0x000000);
            buttonText.text = "Start Test";
            buttonText.mouseEnabled = false;
            var button:Sprite = new Sprite();
            button.graphics.beginFill(0xDDDDDD);
            button.graphics.lineStyle(2, 0x999999);
            button.graphics.drawRoundRect(0,0,70,18,15);
            button.buttonMode = true;
            button.addChild(buttonText);
            return button;
        }
    }
}

import flash.utils.getTimer;

class StockVO {
    public var minute:uint;
    public var value:Number;
    public function StockVO(minute:uint, value:Number){
        this.minute = minute;
        this.value = value;
    }
}
class FPSMeter {
    private var sampleFPS:Number = 0;
    private var lastSampledTime:uint = 0;
    private var sampleFrames:Number = 0;
    
    public var sampleDuration:uint = 500;
    public function increment():void {
        sampleFrames++;
    }
    public function getFramerate():Number {
        var diff:uint = getTimer()-lastSampledTime;
        if(diff >= sampleDuration){
            var rawFPS:int = sampleFrames/(diff/1000);
            //sampleFPS = FPSMeter.formatNumber(rawFPS);
            sampleFPS = rawFPS;
            sampleFrames = 0;
            lastSampledTime = getTimer();
        }
        return sampleFPS;
    }
    public static function formatNumber(val:Number):Number{
        //format as XX.XX
        return Math.floor(val*100)/100;
    }
}
