/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qMqU
 */

//ugokan dareka osietekure
package
{
import com.google.maps.InfoWindowOptions;
import com.google.maps.LatLng;
import com.google.maps.Map;
import com.google.maps.MapEvent;
import com.google.maps.MapType;
import com.google.maps.overlays.Marker;
import com.google.maps.overlays.MarkerOptions;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageDisplayState;
import flash.display.StageScaleMode;
import flash.events.MouseEvent;
import flash.geom.Point;
public class GoogleMapSample extends Sprite
{
    private static var LATLNG : LatLng = new LatLng(38.0, 140.0);
    private static const ZOOM : int = 16;
    private var map : Map;
    public function GoogleMapSample()
    {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        map = this.createMap();
        this.addChild(map);
        stage.addEventListener(MouseEvent.CLICK, onClickHandler);
    }
    private function createMap() : Map
    {
        var map : Map = new Map();
        map.setSize(new Point( stage.stageWidth, stage.stageHeight));
        map.addEventListener(MapEvent.MAP_READY, mapReadyHandler);
        map.key = "
        return map;
    }
    private function mapReadyHandler(event : MapEvent) : void
    {
        map.setCenter(LATLNG, ZOOM, MapType.NORMAL_MAP_TYPE);
        map.enableScrollWheelZoom();
        map.enableContinuousZoom();
        var marker : Marker = new Marker(LATLNG, new MarkerOptions(
        {
            radius : 12,
            hasShadow : true
        }));
        map.addOverlay(marker);
    }
    private function onClickHandler(event : MouseEvent) : void
    {
        if (stage.displayState != StageDisplayState.FULL_SCREEN)
        {
            stage.displayState = StageDisplayState.FULL_SCREEN;
            map.setSize(new Point( stage.stageWidth, stage.stageHeight));
        }
    }
}
}
