/**
 * Copyright songoo ( http://wonderfl.net/user/songoo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qMcsQ
 */

// forked from goldsource's Draw Something
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", frameRate="60")]
    /**
     * Draw Something
     * @author Nicholas Schreiber
     * @version 1 
     * */
    public class DrawSomething extends Sprite
    {
        private static const WIDTH:uint = 465;
        private static const HEIGHT:uint = 465;
        private static const SCREEN_BG_COLOR:uint = 0xFFFFFF;
        private static const SEGMENTS_PER_FRAME:uint = 12;
        private static const MIN_LINE_SIZE:uint = 1;
        private static const MAX_LINE_SIZE:uint = 6;
        private static const MIN_SCALE:Number = .1;
        private static const MAX_SCALE:Number = 1;
        private static const MAX_ANGLE:Number = 360;        
        private static const CANVAS_ALPHA:Number = .8;
        private static const CANVAS_LINE_SIZE:Number = 3;
        private static const CANVAS_LINE_COLOR:uint = 0x000000;
        private static const CANVAS_BG_COLOR:uint = 0xFFFFFF;
        private var __screen:Bitmap = new Bitmap(new BitmapData(WIDTH,HEIGHT,false,SCREEN_BG_COLOR),PixelSnapping.AUTO,true);
        private var __canvas:Bitmap = new Bitmap(new BitmapData(WIDTH,HEIGHT,false,CANVAS_BG_COLOR),PixelSnapping.AUTO,true);
        private var __shape:VectorShape = new VectorShape();
        private var __cursor:uint;
        private var __lineColor:uint;
        private var __lineSize:uint;
        private var __angle:Number;
        private var __origin:VectorShapePoint;
        private var __scale:Number;
        private var __description:Description = new Description();
        public function DrawSomething()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            __canvas.alpha = CANVAS_ALPHA;
            __randomize();
            addChild(__screen);
            addChild(__description);
            __description.x = (WIDTH-__description.width)/2;
            __description.y = (HEIGHT-__description.height)/2;
            stage.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
            stage.addEventListener(Event.ENTER_FRAME,__onEnterFrame);
        }
        
        private function __onEnterFrame($e:Event):void{
            if(__shape.points.length<2)return;
            for(var i:uint=0;i<SEGMENTS_PER_FRAME;i++)__renderSegment();
        }
        
        private function __renderSegment():void{                
            if(__shape.points.length<2)return;
            var from:VectorShapePoint = VectorShapeUtil.rotatePoint(__shape.points[__cursor], __shape.origin, __angle);
            var to:VectorShapePoint = VectorShapeUtil.rotatePoint(__shape.points[__cursor+1], __shape.origin, __angle);
            from.x *=__scale;
            from.y *=__scale;
            to.x *=__scale;
            to.y *=__scale;
            from.x +=__origin.x;
            from.y +=__origin.y;
            to.x +=__origin.x;
            to.y +=__origin.y;                
            VectorShapeUtil.line(__screen.bitmapData,from,to,__lineColor,__lineSize);        
            if(__cursor == __shape.points.length-2){
                __randomize();
            }else{
                __cursor++
            }            
        }
        
        private function __randomize():void{
            __cursor = 0;
            __scale = MIN_SCALE+Math.random()*(MAX_SCALE-MIN_SCALE);
            __lineColor = Math.random()*0xFFFFFF;
            __lineSize = MIN_LINE_SIZE+Math.random()*(MAX_LINE_SIZE-MIN_LINE_SIZE);
            __angle = Math.random()*MAX_ANGLE;            
            __origin = new VectorShapePoint(Math.random()*WIDTH,Math.random()*HEIGHT);
        }
        
        private function __reset():void{
            if(contains(__description))removeChild(__description);
            __cursor = 0;
            __shape.reset();
        }        
        
        private function __addPoint($x:uint,$y:uint):void{            
            __shape.points.push(new VectorShapePoint($x,$y));            
            if(__shape.points.length<2)return;
            VectorShapeUtil.line(__canvas.bitmapData,__shape.points[__shape.points.length-2],__shape.points[__shape.points.length-1],CANVAS_LINE_COLOR,CANVAS_LINE_SIZE);
        }
        
        private function __onMouseDown($e:MouseEvent):void{            
            __reset();
            __shape.origin.x = mouseX;
            __shape.origin.y = mouseY;
            __showCanvas();
            __addListeners();
        }
            
        private function __onMouseUp($e:MouseEvent):void{            
            __hideCanvas();
            __removeListeners();
        }
                
        private function __onMouseLeave($e:Event):void{
            __hideCanvas();
            __removeListeners();            
        }
        
        private function __onMouseMove($e:MouseEvent):void{
            __addPoint(mouseX, mouseY);
            $e.updateAfterEvent();
        }
        
        private function __showCanvas():void{
            __canvas.bitmapData.fillRect(__canvas.bitmapData.rect,CANVAS_BG_COLOR);
            if(!contains(__canvas))
            addChild(__canvas);
        }
        
        private function __hideCanvas():void{            
            if(contains(__canvas))                
            removeChild(__canvas);
        }        
        
                
        private function __addListeners():void{
            stage.removeEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);        
            stage.removeEventListener(Event.ENTER_FRAME,__onEnterFrame);    
            stage.addEventListener(MouseEvent.MOUSE_MOVE,__onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
            stage.addEventListener(Event.MOUSE_LEAVE,__onMouseLeave);
        }
        
        private function __removeListeners():void{
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,__onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
            stage.removeEventListener(Event.MOUSE_LEAVE,__onMouseLeave);    
            stage.addEventListener(Event.ENTER_FRAME,__onEnterFrame);    
            stage.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);            
        }
    }
}
import flash.display.BitmapData;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

internal class VectorShapeUtil{
    
    public static function rotatePoint($point:VectorShapePoint, $offset:VectorShapePoint, $angle:Number):VectorShapePoint{
        var np:VectorShapePoint = new VectorShapePoint();
        np.x = (($point.x-$offset.x) * Math.cos($angle * (Math.PI/180))) - (($point.y-$offset.y) * Math.sin($angle * (Math.PI/180)));
        np.y = Math.sin($angle * (Math.PI/180)) * ($point.x-$offset.x) + Math.cos($angle * (Math.PI/180)) * ($point.y-$offset.y);
        return np;
    }
    
    public static function line($bitmap:BitmapData,$from:VectorShapePoint,$to:VectorShapePoint,$color:uint,$radius:uint):void{
        var angle:Number = getAngle($from.x,$from.y,$to.x,$to.y);
        var distance:Number = getDistance($from.x,$from.y,$to.x,$to.y);
        for(var i:uint =0;i<distance;i++){
            var tP:VectorShapePoint = new VectorShapePoint( $from.x + i *Math.cos(angle*Math.PI/180),$from.y + i *Math.sin(angle*Math.PI/180));
            filledCircle($bitmap,tP,$color,$radius)
        }
    }        
    
    public static function filledCircle($bitmap:BitmapData,$point:VectorShapePoint,$color:uint,radius:uint=1):void{
        for (var i:uint=0;i<radius;i++){
            var perimeter:uint = Math.max(1,2*i*Math.PI);                
            for (var k:uint =0;k< perimeter;k++){
                var tx:uint = $point.x + i *Math.cos(360*(k/perimeter)*Math.PI/180);
                var ty:uint = $point.y + i *Math.sin(360*(k/perimeter)*Math.PI/180);
                $bitmap.setPixel(tx,ty,$color);
            }
        }
    }
    
    public static function getAngle($x1:Number,$y1:Number,$x2:Number,$y2:Number):Number{
        return Math.atan2($y2 - $y1, $x2 - $x1) * 180 / Math.PI;
    }
    
    public static function getDistance($x1:Number,$y1:Number,$x2:Number,$y2:Number):Number{                
        return Math.sqrt(Math.pow($x1-$x2, 2)+Math.pow($y1-$y2, 2));
    }
}

internal class VectorShape{
    private var __origin:VectorShapePoint = new VectorShapePoint();
    private var __points:Vector.<VectorShapePoint> = new Vector.<VectorShapePoint>;
    public function VectorShape(){
        reset();
    }
    
    public function reset():void{    
        while(__points.length>0)delete __points.pop();
    }
    
    public function get points():Vector.<VectorShapePoint>
    {
        return __points;
    }

    public function get origin():VectorShapePoint
    {
        return __origin;
    }

    public function set origin(value:VectorShapePoint):void
    {
        __origin = value;
    }

}

internal class VectorShapePoint{
    public var x:Number = 0;
    public var y:Number = 0;
    public function VectorShapePoint($x:Number=0,$y:Number=0){
        x = $x;
        y = $y;
    }
}

internal class Description extends TextField{
    public function Description(){
        width = height = 1;
        selectable =false;
        mouseEnabled = false;
        autoSize=TextFieldAutoSize.LEFT;
        defaultTextFormat = new TextFormat("_sans",40,0,true);
        text = "DRAW SOMETHING!";
    }
}