/**
 * Copyright kooo ( http://wonderfl.net/user/kooo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qMEO
 */

// forked from simultechnology's あなろぐ時計
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    public class Clock extends Sprite
    {
        public function Clock()
        {
            init();
        }
        
        private function init():void 
        {
            // 中心点の設定
            var center_x:int = 465/2;
            var center_y:int = 465/2;
            // 時計のカラー
            var clock_color:int = 0x2F4F4F;
            // 時計の円を描写
            this.graphics.lineStyle(3, clock_color);
            this.graphics.drawCircle(center_x, center_y, 150);
            
            // 時刻の数字を表示するテキストフォーマット
            var tf:TextFormat = new TextFormat();
            tf.font = "Gothic";
            tf.color = clock_color;
            tf.size = 20;
            
            var time:int = 1;
            for (var degree:int = 0; degree < 360; degree += 360 / 60)
            {
                // 角度が30の倍数の時（時刻の数字が5,10,15....）
                if (degree % 30 == 0) {
                    var rect:Sprite = new Sprite();
                    rect.graphics.beginFill(clock_color);
                    rect.graphics.drawRoundRect(0, 0, 20, 3, 2);
                    rect.graphics.endFill();
                    rect.x = center_x + Math.cos(degree * Math.PI / 180) * 130;
                    rect.y = center_y + Math.sin(degree * Math.PI / 180) * 130;
                    rect.rotation = degree;
                    addChild(rect);
                    
                    var text_field:TextField = new TextField();
                    text_field.defaultTextFormat = tf;
                    text_field.text = time.toString();
                    time++;
                    text_field.x = center_x - 8 + Math.cos(degree * Math.PI / 180 - 45) * 117;
                    text_field.y = center_y - 13  + Math.sin(degree * Math.PI / 180 - 45) * 117;
                    addChild(text_field);
                }
                else {
                    var rect:Sprite = new Sprite();
                    rect.graphics.beginFill(clock_color);
                    rect.graphics.drawRoundRect(0, 0, 10, 1, 2);
                    rect.graphics.endFill();
                    rect.x = center_x + Math.cos(degree * Math.PI / 180) * 140;
                    rect.y = center_y + Math.sin(degree * Math.PI / 180) * 140;
                    rect.rotation = degree;
                    addChild(rect);
                }
            }

            var hour_hand:Sprite;    // 時針
            var minute_hand:Sprite;    // 分針
            var second_hand:Sprite;    // 秒針

            // 秒針の設定
            second_hand = new Sprite();
            second_hand.graphics.beginFill(0x2F4F4F);
            second_hand.graphics.moveTo(0, 0);
            second_hand.graphics.lineTo(0, 1);
            second_hand.graphics.lineTo(140, 0);
            second_hand.graphics.lineTo(0, -1);
            second_hand.graphics.lineTo(0, 0);
            second_hand.graphics.endFill();
            second_hand.x = center_x;
            second_hand.y = center_y;
            addChild(second_hand);
            
            // 分針の設定
            minute_hand = new Sprite();
            minute_hand.graphics.beginFill(0x4169E1);
            minute_hand.graphics.moveTo(0, 0);
            minute_hand.graphics.lineTo(0, 5);
            minute_hand.graphics.lineTo(130, 0);
            minute_hand.graphics.lineTo(0, -5);
            minute_hand.graphics.lineTo(0, 0);
            minute_hand.graphics.endFill();
            minute_hand.x = center_x;
            minute_hand.y = center_y;
            addChild(minute_hand);
            
            // 時針の設定
            hour_hand = new Sprite();
            hour_hand.graphics.beginFill(0xDC143C);
            hour_hand.graphics.moveTo(0, 0);
            hour_hand.graphics.lineTo(0, 10);
            hour_hand.graphics.lineTo(100, 0);
            hour_hand.graphics.lineTo(0, -10);
            hour_hand.graphics.lineTo(0, 0);
            hour_hand.graphics.endFill();
            hour_hand.x = center_x;
            hour_hand.y = center_y;
            addChild(hour_hand);
            
            // 中心の円を描写
            var center_ball:Sprite = new Sprite();
            center_ball.graphics.beginFill(clock_color);
            center_ball.graphics.drawCircle(center_x, center_y, 15);
            this.addChildAt(center_ball, this.numChildren);

            this.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                var date:Date = new Date();
                // 針は最初、水平方向に作っているが、時計の針は90度スタートなので-90する。
                second_hand.rotation = date.getSeconds() * 6 - 90;
                minute_hand.rotation = date.getMinutes() * 6 - 90;
                hour_hand.rotation = date.getHours() * 30 + date.getMinutes() * 6 / 12  - 90;    
            });
        }
    }
}