/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qKj5
 */

/**
 * Papervision3D Sample MeshCuttingExample
 */
package {
    import flash.events.Event;
    import flash.display.BitmapData;
    
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.MeshUtil;
    import org.papervision3d.materials.BitmapColorMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.render.QuadrantRenderEngine;
    
    public class FlashTest extends BasicView {
        
        private var _planeMaterial:BitmapColorMaterial;
        private var _sphereMaterial:BitmapMaterial;
        
        private var _sourceSphere:Sphere;
        private var _hemiSphereA:TriangleMesh3D;
        private var _hemiSphereB:TriangleMesh3D;
        
        public function FlashTest() {
            super(0,0,true,false);
            opaqueBackground = 0;
            setupScene();
        }
        
        protected function setupScene():void {
            var bmp:BitmapData = new BitmapData(512,255,false,0);
            bmp.perlinNoise(64,64,4,123456,true,false);
            
            _sphereMaterial = new BitmapMaterial(bmp);
            _sphereMaterial.doubleSided = true;
            _sourceSphere = new Sphere(_sphereMaterial, 400, 15, 15);
            
            var normal:Number3D = new Number3D(0.1, 0.9, 0.5);
            var point:Number3D = new Number3D(0, 10, 0);
            var cutPlane:Plane3D = Plane3D.fromNormalAndPoint(normal, point);
            
            var meshes:Array = MeshUtil.cutTriangleMesh(_sourceSphere, cutPlane);
            
            _hemiSphereA = meshes[0];
            _hemiSphereA.x = 400;
            _hemiSphereA.z = 200;
            scene.addChild(_hemiSphereA);
            
            _hemiSphereB = meshes[1];
            _hemiSphereB.x = -400;
            _hemiSphereB.z = 200;
            scene.addChild(_hemiSphereB);
            
            startRendering();
        }
        
        override protected function onRenderTick(event:Event=null):void {
            _hemiSphereA.yaw(1);
            _hemiSphereB.yaw(-1);
            super.onRenderTick(event);
        }


    }
}