/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qKcq
 */

// forked from Qwaz's Observe Box
package {

    import flash.display.MovieClip;
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.core.Sorting;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.materials.FillMaterial;
    
    import com.bit101.components.CheckBox;
    import com.bit101.components.PushButton;
    import com.bit101.components.Window;
    
    import gs.TweenLite;
    
    import flash.events.ContextMenuEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuItem;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    
    [SWF (width="400", height="400")]

    public class Main extends MovieClip {

        var container:ConflictContainer;
        var camera:Camera3D;
        var boxArr:Vector.<Box>;
        
        var targetX:Number;
        var targetY:Number;
        var targetZ:Number;
        var targetRotX:Number;
        var targetRotY:Number;
        var targetRotZ:Number;
        
        var rotatedChk:CheckBox;
        var elasticChk:CheckBox;
        
        var rotated:Boolean=false;
        var elastic:Boolean=false;
        
        const ROTATION_MULTIPLIER:Number = 360/180*Math.PI;
        const NUM_OF_BOX:int = 200;

        public function Main() {
            init();
            
            addBoxes();
            
            cameraSet();
        }

        private function init():void {
            container = new ConflictContainer();
            camera = container.addChild(new Camera3D()) as Camera3D;
            camera.view = addChild(new View(stage.stageWidth, stage.stageHeight)) as View;
            
            var myContextMenu:ContextMenu = camera.view.contextMenu;
            myContextMenu.hideBuiltInItems();
            var qwazSign:ContextMenuItem = new ContextMenuItem("Qwaz Laboratory (yechan54@naver.com)");
            myContextMenu.customItems.push(qwazSign);
            this.contextMenu = myContextMenu;

            qwazSign.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, gotoBlog);

            function gotoBlog(e:ContextMenuEvent):void{
                navigateToURL(new URLRequest("http://blog.naver.com/yechan54"));
            }
            
            boxArr = new Vector.<Box>;
            
            var window:Window = new Window(this,0,0,"Options");
            window.hasMinimizeButton = true;
            window.height = 75;
            rotatedChk = new CheckBox(window.content,5,5,"Rotated Box");
            elasticChk = new CheckBox(window.content,5,20,"Elastic Camera");
            var resetBtn = new PushButton(window.content,0,35,"Reset",resetStage);
            window.y = stage.stageHeight-window.height;
        }
        
        private function addBoxes():void {
            var box:Box;
            var i:int;
            
            for(i=0; i<NUM_OF_BOX; i++){
                box = new Box(2+16*Math.random(), 2+16*Math.random(), 2+16*Math.random());
                box.setMaterialToAllFaces(new FillMaterial(Math.random()*0xFFFFFF));
                box.x = -100+200*Math.random();
                box.y = -100+200*Math.random();
                box.z = -100+200*Math.random();
                box.sorting = Sorting.DYNAMIC_BSP;
                
                if(!rotated){
                    box.rotationX = 0;
                    box.rotationY = 0;
                    box.rotationZ = 0;
                }else{
                    box.rotationX = Math.random()*ROTATION_MULTIPLIER;
                    box.rotationY = Math.random()*ROTATION_MULTIPLIER;
                    box.rotationZ = Math.random()*ROTATION_MULTIPLIER;
                }
                container.addChild(box);
                boxArr.push(box);
            }
        }
        
        private function adjustCameraPos():void {
            while(camera.rotationX > ROTATION_MULTIPLIER) camera.rotationX -= ROTATION_MULTIPLIER;
            while(camera.rotationY > ROTATION_MULTIPLIER) camera.rotationY -= ROTATION_MULTIPLIER;
            while(camera.rotationZ > ROTATION_MULTIPLIER) camera.rotationZ -= ROTATION_MULTIPLIER;
            
            while(camera.rotationX < 0) camera.rotationX += ROTATION_MULTIPLIER;
            while(camera.rotationY < 0) camera.rotationY += ROTATION_MULTIPLIER;
            while(camera.rotationZ < 0) camera.rotationZ += ROTATION_MULTIPLIER;
        }
        
        private function cameraSet():void {
            TweenLite.killTweensOf(camera);
            adjustCameraPos();
            
            targetX = -50+100*Math.random();
            targetY = -50+100*Math.random();
            targetZ = -50+100*Math.random();
            targetRotX = Math.random()*ROTATION_MULTIPLIER;
            targetRotY = Math.random()*ROTATION_MULTIPLIER;
            targetRotZ = Math.random()*ROTATION_MULTIPLIER;
            
            if(!elastic) {
                if(targetRotX - camera.rotationX > ROTATION_MULTIPLIER/2) targetRotX -= ROTATION_MULTIPLIER;
                if(targetRotY - camera.rotationY > ROTATION_MULTIPLIER/2) targetRotY -= ROTATION_MULTIPLIER;
                if(targetRotZ - camera.rotationZ > ROTATION_MULTIPLIER/2) targetRotZ -= ROTATION_MULTIPLIER;
                if(camera.rotationX - targetRotX > ROTATION_MULTIPLIER/2) targetRotX += ROTATION_MULTIPLIER;
                if(camera.rotationY - targetRotY > ROTATION_MULTIPLIER/2) targetRotY += ROTATION_MULTIPLIER;
                if(camera.rotationZ - targetRotZ > ROTATION_MULTIPLIER/2) targetRotZ += ROTATION_MULTIPLIER;
            
                TweenLite.to(camera, 3.5, {x:targetX, y:targetY, z:targetZ, rotationX:targetRotX, rotationY:targetRotY, rotationZ:targetRotZ, onComplete:cameraSet, onUpdate:camera.render});
            } else {
                if(targetRotX - camera.rotationX < ROTATION_MULTIPLIER/2) targetRotX -= ROTATION_MULTIPLIER;
                if(targetRotY - camera.rotationY < ROTATION_MULTIPLIER/2) targetRotY -= ROTATION_MULTIPLIER;
                if(targetRotZ - camera.rotationZ < ROTATION_MULTIPLIER/2) targetRotZ -= ROTATION_MULTIPLIER;
                if(camera.rotationX - targetRotX < ROTATION_MULTIPLIER/2) targetRotX += ROTATION_MULTIPLIER;
                if(camera.rotationY - targetRotY < ROTATION_MULTIPLIER/2) targetRotY += ROTATION_MULTIPLIER;
                if(camera.rotationZ - targetRotZ < ROTATION_MULTIPLIER/2) targetRotZ += ROTATION_MULTIPLIER;
            
                TweenLite.to(camera, 12, {x:targetX, y:targetY, z:targetZ, rotationX:targetRotX, rotationY:targetRotY, rotationZ:targetRotZ, onComplete:cameraSet, onUpdate:camera.render});
            }
        }
        
        private function resetStage(e:MouseEvent):void {
            rotated = rotatedChk.selected;
            elastic = elasticChk.selected;
            
            for each(var box:Box in boxArr){
                container.removeChild(box);
            }
            boxArr = new Vector.<Box>;
            
            addBoxes();
            
            camera.x = 0;
            camera.y = 0;
            camera.z = 0;
            cameraSet();
        }
    }

}