/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qJak
 */

// forked from bkzen's [朝ワン]Thank you tweener Hello BetweenAS3
package
{
    import caurina.transitions.Tweener;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    /**
     * 動かす直前に addChild するバージョン。(BetweenAS3)
     * Thank you for Tweener
     * BetweenAS3 を使ってみた。
     * 使い方があってるかわからない。
     * 最初の Click で Tweener 2回目で 一度削除
     *　3回目で BetweenAS3
     * 参考)
     * Hello World!!!
     * http://wonderfl.net/code/a59130db3327183d2285068470d8ee7192032a98
     * 1. Simple tweens with BetweenAS3
     * http://wonderfl.net/code/dfc0d52258f94cd48998ac68a9375015764dab35
     * 7. Action integration with BetweenAS3
     * http://wonderfl.net/code/19a1290d8e3a28522d7825408e87ae70c59ce352
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Asawon10 extends Sprite
    {
        private const r2: Number = 6.3;
        private var bd: BitmapData;
        private var phase: int;
        private var txt: TextField;
        
        public function Asawon10()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // 
            addChild(txt = new TextField());
            txt.text = "Click to Start Tweener";
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.x = (465 - txt.width) / 2;
            txt.y = (465 - txt.height);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            play();
        }
        
        private function onClick(e: MouseEvent ): void 
        {
            phase ++;
            play();
        }
        
        private function play(): void
        {
            var i: int, j: int, w: int, h: int, c: Circle, tf: TextField, textFormat: TextFormat;
            trace(phase);
            switch (phase)
            {
                case 0:
                    tf = new TextField();
                    tf.textColor = 0x000000;
                    tf.htmlText = "Thank you for\n<font color='#AA0000'>Tweener</font>\nHello\nBetweenAS3";
                    tf.autoSize = "left";
                    textFormat = tf.getTextFormat();
                    textFormat.align = TextFormatAlign.CENTER;
                    tf.setTextFormat(textFormat);
                    bd = new BitmapData(tf.width, tf.height, false, 0x3399ff);
                    bd.draw(tf);
                    bd.applyFilter(bd, bd.rect, new Point(), new BlurFilter(2, 2));
                    bd.draw(tf);
                break;
                case 1:
                    w = bd.width, h = bd.height;
                    for (i = 0; i < w; i++)
                    {
                        for (j = 0; j < h; j++)
                        {
                            Tweener.addTween(
                                randomize(addChild(new Circle(bd.getPixel(i, j), r2))), 
                                {
                                    x: i * r2,
                                    y: j * r2,
                                    alpha: 1,
                                    delay: (i + j) * .2 * Math.random(),
                                    time: 1
                                }
                            );
                        }
                    }
                    txt.text = "Click to Remove";
                    txt.x = (465 - txt.width) / 2;
                    txt.y = (465 - txt.height);
                break;
                case 2:
                    while (numChildren > 1)
                    {
                        c = Circle(removeChildAt(1));
                        c.graphics.clear();
                    }
                    txt.text = "Click to Start BetweenAS3";
                    txt.x = (465 - txt.width) / 2;
                    txt.y = (465 - txt.height);
                    tf = new TextField();
                    tf.textColor = 0x000000;
                    tf.htmlText = "Thank you for\nTweener\nHello\n<font color='#AA0000'>BetweenAS3</font>";
                    tf.autoSize = "left";
                    textFormat = tf.getTextFormat();
                    textFormat.align = TextFormatAlign.CENTER;
                    tf.setTextFormat(textFormat);
                    bd.dispose();
                    bd = new BitmapData(tf.width, tf.height, false, 0x3399ff);
                    bd.draw(tf);
                    bd.applyFilter(bd, bd.rect, new Point(), new BlurFilter(2, 2));
                    bd.draw(tf);
                break;
                case 3:
                    w = bd.width, h = bd.height;
                    for (i = 0; i < w; i++)
                    {
                        for (j = 0; j < h; j++) 
                        {
                            BetweenAS3.serial(
                                BetweenAS3.delay(
                                    BetweenAS3.addChild(c = new Circle(bd.getPixel(i, j), r2), this), 
                                    (i + j) * .2 * Math.random()
                                ),
                                BetweenAS3.tween(c, {
                                        x: i * r2,
                                        y: j * r2,
                                        alpha: 1
                                    }, null, 1.0, null
                                )
                            ).play();
                        }
                    }
                    removeChild(txt);
                break;
            }
        }
        
        private function randomize(d: DisplayObject): DisplayObject
        {
            d.x = 400 * Math.random();
            d.y = 300 * Math.random();
            d.alpha = 0;
            return d;
        }
    }
}


import flash.display.Graphics;
import flash.display.Shape;

class Circle extends Shape
{
    public function Circle(color: uint, r2: Number)
    {
        var g: Graphics = graphics;
        g.beginFill(color);
        g.drawCircle(0, 0, r2 / 2);
        g.endFill();
    }
}
