/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qIqQ
 */

/*
 * 単純なボックスを並べた透視投影テスト
 */

package {
	
	import flash.display.*;
	import flash.geom.*;
	
	[SWF(width=465,height=465,frameRate=30,backgroundColor=0x88aaff)]
	public class Main extends Sprite {
		
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		public var proj:PerspectiveProjection = new PerspectiveProjection();
		
		public function Main():void {
			proj.fieldOfView = 60;

			var container:Sprite = new Sprite();
			addChild(container);
			container.x = SW/2;
			container.y = SH/2;

			var boxNum:uint = 3;
			var dist:Number = 150;
			var shift:Number = dist*(boxNum-1)/2;
			for (var v:int = 0; v < boxNum; v++) {
				var nY:Number = dist*v-shift;
				for (var h:int = 0; h < boxNum; h++) {
					var nX:Number = dist*h-shift;
					var box:Box = new Box();
					container.addChild(box);
					box.mtx.prepend(proj.toMatrix3D());
					box.mtx.prependTranslation(nX, nY, proj.focalLength);
					box.xRender();
				}
			}
		}
	}
}

import flash.display.*;
import flash.geom.*;

class Box extends Sprite {
	
	private const len:Number = 50;
	public var vertices3D:Vector.<Number> = new Vector.<Number>();
	public var vertices2D:Vector.<Number> = new Vector.<Number>();
	public var indices:Vector.<int> = new Vector.<int>();
	public var uvt:Vector.<Number> = new Vector.<Number>();
	public var mtx:Matrix3D = new Matrix3D();
	
	public function Box():void {
		vertices3D.push(-len,-len, len);
		vertices3D.push( len,-len, len);
		vertices3D.push(-len,-len,-len);
		vertices3D.push( len,-len,-len);
		vertices3D.push(-len, len, len);
		vertices3D.push( len, len, len);
		vertices3D.push(-len, len,-len);
		vertices3D.push( len, len,-len);
		indices.push(2,3,7, 7,6,2);
		indices.push(3,1,5, 5,7,3);
		indices.push(1,0,4, 4,5,1);
		indices.push(0,2,6, 6,4,0);
	}
	
	public function xRender():void {
		Utils3D.projectVectors(mtx,vertices3D,vertices2D,uvt);
		graphics.beginFill(0xffffff,0.5);
		graphics.lineStyle(0,0xffffff);
		graphics.drawTriangles(vertices2D,indices,null);
		graphics.endFill();
	}
}