/**
 * Copyright aass ( http://wonderfl.net/user/aass )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qIdO
 */

// forked from umhr's Yahoo!PipesでAmazon:本 &gt; Flashのベストセラー
/*
 * Yahoo!Pipes
 * http://pipes.yahoo.com/pipes/pipe.info?_id=f4f6c98189a88373b9bfd4fe6128c018
 * 
 * rss
 * http://www.amazon.co.jp/gp/bestsellers/books/713428/ref=pd_zg_hrsr_b_1_5_last
 * */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.net.navigateToURL;
	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor="0xCCCCCC")]
	public class Main extends Sprite {
		public function Main():void {
			//ドキュメントルートのcrossdomain.xml（http://pipes.yahooapis.com/crossdomain.xml）で
			//許可を与えているので、特に指定しなくても自動的に許可を取ってくる。
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener (Event.COMPLETE, onCompleteXML);
			//YahooPipesの汎用feedProxy
			var xmlURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=f4f6c98189a88373b9bfd4fe6128c018&_render=rss&url=";
			//encodeURIComponentでエスケープして、feedProxyにくっつける。
			xmlURL += encodeURIComponent("http://www.amazon.co.jp/rss/bestsellers/books/713428/ref=pd_ts_rss_link");
			myURLLoader.load(new URLRequest(xmlURL));
		}
           
		private function onCompleteXML(e:Event):void {
			var myXML:XML = new XML(e.currentTarget.data);
			var htmldata:String = "<a href='http://www.amazon.co.jp/gp/bestsellers/books/713428/ref=pd_zg_hrsr_b_1_5_last' target='_blank'>";
			htmldata += "Amazon:本 > Flashのベストセラー";
			htmldata += "</a>";
			
			var title:TextField = new TextField();
			title.htmlText = htmldata;
			title.width = 465;
			title.height = 20;
			addChild(title);
			
			var itemLength:int = Math.min(9, myXML.channel.item.length());
			for (var i:int = 0; i < itemLength; i++) {
				//画像のURLを抜き出している。
				var imgURL:String = myXML.channel.item[i].description.split(" src=\"")[1].split("\"")[0];
				var myLoader:Loader = new Loader();
				myLoader.load(new URLRequest(imgURL));
				//画像が読み込めなかった場合にエラーが出ないように。
				myLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, IO_ERROR );
				//キャプチャ完了したものはjpgというファイル名になっているので、その場合は、縮小。
				//完了していない場合は、小さなエラー画像が出るので、その場合は拡大
				if(imgURL.indexOf("jpg")+1){
					myLoader.scaleX = myLoader.scaleY = 0.85;
				}else {
					myLoader.scaleX = myLoader.scaleY = 465*0.85*0.01;
				}
				myLoader.x = 18 + (i % 3) * 150;
				myLoader.y = 20 + Math.floor(i / 3) * 150;
				//ドロップシャドウをかける。
				myLoader.filters = [new DropShadowFilter()];
				//link先をnameに入れる。
				myLoader.name = myXML.channel.item[i].link;
				var tf:TextField = new TextField();
				tf.text = myXML.channel.item[i].title;
				tf.width = 145;
				tf.height = 20;
				tf.x = 10 + (i % 3) * 150;
				tf.y = 150 + Math.floor(i / 3) * 150;
				addChildAt(myLoader, 0);
				addChildAt(tf, 0);
			}
			addEventListener(MouseEvent.CLICK, CLICK);
		}
		private function IO_ERROR(e:IOErrorEvent):void { };
			
		private function CLICK(e:MouseEvent):void {
			//クリックされたら、ターゲットの名前（link先）を取得して、httpがついていたら遷移
			var linkURL:String = e.target.name;
			if (linkURL.indexOf("http") + 1) {
				navigateToURL(new URLRequest(linkURL) );
			}
		}
	}
}