/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qIJ6
 */

package
{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import flash.display.GraphicsPath;
    import flash.display.GraphicsPathWinding;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    [ SWF( frameRate = "60" ) ]
    public class DrawBridge extends Sprite
    {
        private const MAX_RADIUS:Number = 100;
        private var startRadius:Number;
        private var endRadius:Number;
        private var startSlider:HSlider;
        private var endSlider:HSlider;
        private var startControl:PointControl;
        private var endControl:PointControl;
        public function DrawBridge()
        {
            startRadius = 10;
            endRadius = 20;
            new Label( this, 20, 10, "start" );
            new Label( this, 20, 30, "end" );
            startSlider = new HSlider( this, 50, 15, function():void {
                startRadius = startSlider.value * MAX_RADIUS / 100;
                startControl.radius = startRadius;
                startControl.draw();
            } );
            startSlider.value = startRadius / MAX_RADIUS * 100;
            endSlider = new HSlider( this, 50, 35, function():void {
                endRadius = endSlider.value * MAX_RADIUS / 100;
                endControl.radius = endRadius;
                endControl.draw();
            } );
            endSlider.value = endRadius / MAX_RADIUS * 100;
            addEventListener( Event.ENTER_FRAME, ENTER_FRAME );
            startControl = addChild( new PointControl( 0xFF0000, startRadius ) ) as PointControl;
            startControl.x = 100;
            startControl.y = 200;
            endControl = addChild( new PointControl( 0x0000FF, endRadius ) ) as PointControl;
            endControl.x = 300;
            endControl.y = 200;
        }
        private function ENTER_FRAME( e:Event ):void
        {
            startControl.updatePoint();
            endControl.updatePoint();
            graphics.clear();
            graphics.beginFill( 0 );
            drawBridge( startControl.point, endControl.point, startRadius, endRadius );
            graphics.endFill();
        }
        private function drawBridge(
            start:Point,
            end:Point,
            startRadius:Number,
            endRadius:Number ):void
        {
            var angle:Number = Math.atan2( end.y - start.y, end.x - start.x );
            var quarter:Number = Math.PI * 0.5;
            var left:Number = angle + quarter;
            var right:Number = angle - quarter;
            var p0:Point = Point.polar( startRadius, left ).add( start );
            var p1:Point = Point.polar( startRadius, right ).add( start );
            var p2:Point = Point.polar( endRadius, right ).add( end );
            var p3:Point = Point.polar( endRadius, left ).add( end );
            graphics.moveTo( p0.x, p0.y );
            graphics.lineTo( p1.x, p1.y );
            graphics.lineTo( p2.x, p2.y );
            graphics.lineTo( p3.x, p3.y );
            graphics.lineTo( p0.x, p0.y );
        }
    }
}
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Point;
internal class PointControl extends Sprite
{
    public var point:Point;
    public var color:uint;
    public var radius:Number;
    public function PointControl( color:uint, radius:Number )
    {
        this.point = new Point;
        this.color = color;
        this.radius = radius;
        draw();
        addEventListener( MouseEvent.MOUSE_DOWN, MOUSE_DOWN );
    }
    public function draw():void
    {
        graphics.clear();
        graphics.beginFill( color );
        graphics.drawCircle( 0, 0, radius );
        graphics.endFill();
    }
    private function MOUSE_DOWN( e:MouseEvent ):void
    {
        startDrag();
        stage.addEventListener( MouseEvent.MOUSE_UP, MOUSE_UP );
    }
    private function MOUSE_UP( e:MouseEvent ):void
    {
        stopDrag();
        stage.removeEventListener( MouseEvent.MOUSE_UP, MOUSE_UP );
    }
    public function updatePoint():void
    {
        point.x = x;
        point.y = y;
    }
    public function updateControl():void
    {
        x = point.x;
        y = point.y;
    }
}