/**
 * Copyright nutsu ( http://wonderfl.net/user/nutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qHpE
 */

// forked from 9re's Wonderfl Tank Game BulletRenderer Sample 1
// このコードを新着弾一覧http://flash-games.wonderfl.net/tank/list/bullets
// に表示させるためにはinfinite-tank-bullet
// というタグを追加してください
package
{
	// ai0
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Dictionary;
	//
	// net.wonderfl
	import net.wonderfl.game.infinity_tank.development.BulletRendererBase;
	import net.wonderfl.game.infinity_tank.development.BattleScene;
	import net.wonderfl.game.infinity_tank.development.BoundBox;
	import net.wonderfl.math.*;
	
	[SWF(backgroundColor="#000000")]
	public class BulletRenderer extends BulletRendererBase
	{
		private var _ctfm:ColorTransform;
		private var _sp:Shape;
		private var _a:Number;
		private var _tmp:Dictionary;
		
		public function BulletRenderer() {
			_ctfm = new ColorTransform(0.96,1,1,0.8);
			_sp = new Shape();
			_a = 0;
			_tmp = new Dictionary();
		}

		
		override public function draw($bitmapData:BitmapData):void {
		    var ex:Number = _scene.enemyTankPosition.x;
		    var ey:Number = _scene.enemyTankPosition.y;
		    var mx:Number = _scene.myTankPosition.x;
		    var my:Number = _scene.myTankPosition.y;
		    
		    _sp.graphics.clear();
		    _sp.graphics.lineStyle( 2, 0xffffff, 1 );
		    
			$bitmapData.lock();
			$bitmapData.colorTransform($bitmapData.rect, _ctfm);
			var amp:Number = Math.sin(_a)*3;
 			for (var i:BoundBox = _scene.myBulletList; i; i = i.next) {
 			    var v:WVector2D = i.linearVelocity;
 			    var x1:Number = i.position.x - amp*v.y/v.length;
 			    var y1:Number = i.position.y + amp*v.x/v.length;
 			    if( _tmp[i] == null ){
 			        _tmp[i] = new Point(x1,y1);
 			    }else{
 			        var pre:Point = _tmp[i];
 			        _sp.graphics.moveTo( pre.x, pre.y );
 			        _sp.graphics.lineTo( x1, y1 );
 			        pre.x = x1;
 			        pre.y = y1;
 			    }
 			    
 			    //$bitmapData.setPixel32( x1, y1, 0xffffffff );
				/*
				var bx:Number = i.position.x;
				var by:Number = i.position.y;
				var x2:Number = bx - ex;
				var y2:Number = by - ey;
				 _sp.graphics.moveTo( mx, my );
				 _sp.graphics.curveTo( bx, by, ex, ey );
				*/
			}
			$bitmapData.draw( _sp );
			$bitmapData.unlock();
			
			_a += 0.8;
		}
		
	}

}
