/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qHUE
 */

// forked from civet's Bad Apple!! 東方･影絵  × Pixel3D
//---------------------------
//CW/CCW/Zero Rotate: [Z] [X] [C]
//Pause/Resume: [SPACE]
//Seek: [LEFT] [RIGHT]
//Volume: [UP] [DOWN]
//2010-03-22 01:52:57
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.net.NetStream;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.utils.Timer;
    
    [SWF(backgroundColor="0xffffff", frameRate="25")]
    
    public class BadAppleAgain extends Sprite
    {
        private var WIDTH:int = 640;
        private var HEIGHT:int = 480;
        private var VIDEO_WIDTH:int = 120;
        private var VIDEO_HEIGHT:int = 68;
        
        private var container:Sprite;
        private var block:Sprite;
        private var tf:TextField;
        private var buffer:BitmapData;
        private var bmp:Bitmap;
        private var matrix:Matrix;
        private var buffer2:BitmapData;
        private var canvas:Bitmap;
        
        private var player:VideoPlayer;
        private var stream:NetStream;
        private var bar:Sprite;
        private var slider:Shape;
        private var paused:Boolean;
        private var frozen:Boolean;
        
        public function BadAppleAgain()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            Security.loadPolicyFile("http://dreamana.com/crossdomain.xml");
            init();
        }
        
        private function init():void
        {
            //Video
            player = new VideoPlayer(VIDEO_WIDTH, VIDEO_HEIGHT);
            player.addEventListener(Event.OPEN, onOpen);
            player.addEventListener(Event.COMPLETE, onComplete);
            player.volume = 0.5;
            player.x = 10;
            player.y = 10;
            
            //Label
            tf = new TextField();
            tf.mouseEnabled = false;
            tf.selectable = false;
            tf.defaultTextFormat = new TextFormat("Arial", 11, 0, true);
            tf.width = 80;
            tf.height = 20;
            tf.x = 30;
            tf.y = 84;
            
            //Block
            block = new Sprite();
            block.graphics.beginFill(0xffffff);
            block.graphics.drawRect(0, 0, VIDEO_WIDTH + 20, VIDEO_HEIGHT + 40);
            block.graphics.endFill();
            block.filters = [new DropShadowFilter(1, 45, 0x666666, 1, 4, 4)];
            block.x = 10;
            block.y = 10;
            
            block.addChild(player);
            block.addChild(tf);
            
            //Bitmap
            buffer = new BitmapData(VIDEO_WIDTH + 26, VIDEO_HEIGHT + 46, true, 0x00000000);
            matrix = new Matrix();
            matrix.translate(2, 2);
            bmp = new Bitmap(buffer);
            bmp.smoothing = true;
            
            //Container
            container = new Sprite();
            container.addChild(bmp);
            
            //Canvas
            buffer2 = new BitmapData(WIDTH, HEIGHT, false, 0xffffff);
            canvas = new Bitmap(buffer2);
            this.addChild(canvas);
            
            //UI
            bar = new Sprite();
            bar.graphics.beginFill(0xffffff);
            bar.graphics.drawRect(0, 0, 1, 10);
            bar.graphics.endFill();
            bar.y = stage.stageHeight - bar.height -2;
            stage.addChild(bar);
            
            slider = new Shape();
            slider.graphics.beginFill(0);
            slider.graphics.drawRect(0, 0, 1, 4);
            slider.graphics.endFill();
            slider.y = bar.y + 3;
            stage.addChild(slider);
            
            bar.addEventListener(MouseEvent.MOUSE_DOWN, onSeek);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            stage.addEventListener(Event.RESIZE, onResize);
            
            //start
            stream = player.play("http://dreamana.com/lab/badapple/BadApple.mp4");
        }
        
        private function formatLabel(num:int):String
        {
            var n:String = num.toString();
            var i:int = 4-n.length;
            while(i--) n = "0" + n;
            return "BA_" + n + ".bmp";
        }
        
        private var count:int = 0;
        private var shift:int = 0;
        private function update(e:Event):void
        {
            tf.text = formatLabel(count++);
            buffer.fillRect(buffer.rect, 0);
            buffer.draw(block, matrix);
            
            bmp.x = container.mouseX - 70 + int(Math.random() * 4 - 2);
            bmp.y = container.mouseY - 54 + int(Math.random() * 4 - 2);
            if(shift != 0) bmp.rotation += shift * 15;
            
            buffer2.draw(container);
        }
                
        //-- video opened --
        private function onOpen(e:Event):void    
        {
            this.addEventListener(Event.ENTER_FRAME, update);
            
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, onTick);
            timer.start();
        }
        
        //-- video completed --
        private function onComplete(e:Event):void
        {
            if(player.meta.duration - stream.time < 2) {
                frozen = true;
                this.removeEventListener(Event.ENTER_FRAME, update);
            }    
        }
        
        //-- UI --
        private function onTick(e:Event):void
        {
            bar.scaleX = stream.bytesLoaded / stream.bytesTotal * stage.stageWidth;
            slider.scaleX = stream.time / player.meta.duration * stage.stageWidth;
        }
        
        private function onSeek(e:Event):void
        {
            var pos:Number = player.meta.duration * (stage.mouseX / stage.stageWidth);
            stream.seek(pos);
            
            if(frozen) {
                this.addEventListener(Event.ENTER_FRAME, update);
                frozen = false;
            }
        }
        
        private function onResize(e:Event):void
        {
            bar.y = stage.stageHeight - bar.height - 2;
            slider.y = bar.y + 3;
            
            canvas.x = int((stage.stageWidth - canvas.width)/2);
            canvas.y = int((stage.stageHeight - canvas.height)/2);
            container.x = canvas.x;
            container.y = canvas.y;
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.UP:
                    if(player.volume < 1) player.volume += 0.1;
                    break;
                case Keyboard.DOWN:
                    if(player.volume > 0) player.volume -= 0.1;
                    break;
                case Keyboard.RIGHT:
                    stream.seek( stream.time + 10 );
                    break;
                case Keyboard.LEFT:
                    stream.seek( stream.time - 10 );
                    break;
                case Keyboard.SPACE:
                    paused = !paused;
                    stream.togglePause();                    
                    if(paused) this.removeEventListener(Event.ENTER_FRAME, update);
                    else this.addEventListener(Event.ENTER_FRAME, update);                    
                    break;
                case 90:
                    shift = -1;
                    break;
                case 88:
                    shift = 1;
                    break;
                case 67:
                    shift = 0;
                    bmp.rotation = 0;
                    break;
            }
        }
        
        private function onKeyUp(e:KeyboardEvent):void
        {
            switch(e.keyCode) {
                case 90:
                case 88:
                    shift = 0;
                    break;
            }
        }
        
    }
}


import flash.display.Shape;
import flash.display.Sprite;
import flash.events.AsyncErrorEvent;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.NetStatusEvent;
import flash.media.SoundTransform;
import flash.media.Video;
import flash.net.NetConnection;
import flash.net.NetStream;

/**
 * FLV Player
 * @author civet
 */
class VideoPlayer extends Sprite
{
    public static const NO_SCALE:int = 0;
    public static const EXACT_FIT:int = 1;
    public static const MAINTAIN_ASPECT_RATIO:int = 2;
    
    public var meta:Object = {};
    private var stream:NetStream;
    private var _volume:Number = 1.0;
    private var _scaleMode:int = 0;
    private var video:Video;
    private var block:Shape;
    
    public function VideoPlayer(blockWidth:int, blockHeight:int, scaleMode:int=0)
    {
        this._scaleMode = scaleMode;
        
        block = new Shape();
        addChild(block);
        block.graphics.clear();
        block.graphics.beginFill(0);
        block.graphics.drawRect(0, 0, blockWidth, blockHeight);
        block.graphics.endFill();
        
        var nc:NetConnection = new NetConnection();
        nc.connect(null);
        stream = new NetStream(nc);
        stream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
        stream.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        stream.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        stream.client = this;
        
        video = new Video();
        video.smoothing = true; //bug: [FP-178] Video.clear() fails, fp10.1 fixed
        addChild(video);
        
        video.attachNetStream(stream);
    }
    
    public function play(url:String=""):NetStream
    {
        if(url != "") {
            stream.play(url);
        }
        else {
            stream.resume();
        }
        return stream;
    }
    
    public function stop():void
    {
        stream.close();
        video.clear();
    }
    
    public function pause():void
    {
        stream.pause();
    }
    
    public function get volume():Number
    {
        return stream.soundTransform.volume;
    }
    
    public function set volume(value:Number):void
    {
        _volume = value;
        
        var t:SoundTransform = stream.soundTransform;
        t.volume = _volume;
        stream.soundTransform = t;
    }
    
    private function resizeVideo(videoWidth:int, videoHeight:int):void
    {
        if(video.videoWidth != 0) videoWidth = video.videoWidth;
        if(video.videoHeight != 0) videoHeight = video.videoHeight;
        var w:Number;
        var h:Number;
        if(_scaleMode == NO_SCALE) {
            w = videoWidth;
            h = videoHeight;
            video.width = w;
            video.height = h;
            video.x = int((block.width - w) /2) + block.x;
            video.y = int((block.height - h) /2) + block.y;
        }
        else if(_scaleMode == EXACT_FIT) {
            video.width = block.width;
            video.height = block.height;
            video.x = block.x;
            video.y = block.y;
        }
        else if(_scaleMode == MAINTAIN_ASPECT_RATIO) {
            w = (videoWidth / videoHeight) * block.height;
            h = block.height;
            if(w > block.width) {
                w = block.width;
                h = (videoHeight / videoWidth) * block.width;
            }
            video.width = w;
            video.height = h;
            video.x = int((block.width - w) /2) + block.x;
            video.y = int((block.height - h) /2) + block.y;
        }
        
        this.dispatchEvent(new Event(Event.RESIZE));
    }
    
    private function asyncErrorHandler(e:AsyncErrorEvent):void {
        //ignore error
    }
    
    private function ioErrorHandler(e:IOErrorEvent):void {
        trace(e.text);
    }
    
    private function netStatusHandler(e:NetStatusEvent):void
    {
        switch(e.info.code) {
            case "NetStream.Play.Stop":
                dispatchEvent(new Event(Event.COMPLETE));
                break;
            case "NetStream.Play.Start":
                dispatchEvent(new Event(Event.OPEN));            
                break;
        }
    }
    
    /* NetStream client Event Hanlders */
    public function onMetaData(info:Object):void {
        //trace("metadata: duration=" + info.duration + " width=" + info.width + " height=" + info.height + " framerate=" + info.framerate);
        meta = info;
        resizeVideo(info.width, info.height);
    }
    
    public function onCuePoint(info:Object):void {
        //trace("cuepoint: time=" + info.time + " name=" + info.name + " type=" + info.type);
    }
}