/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qHQO
 */

// forked from takishiki's forked from: forked from: Sound Spectrum Ring
// forked from takishiki's forked from: Sound Spectrum Ring
// forked from takishiki's Sound Spectrum Ring
/*
 * 2重にしてみた。graphicsの複製の方法がわからなかったのでdrawを使用。 
 * 
 * よりデジタル風にしてみた。 
 * 
 * sound spectrum
 * サウンドスペクトル表示
 * 
 * ♪使用音楽素材について♪
 * 音楽素材/魔王魂（http://maoudamashii.jokersounds.com/）の素材を使わせていただきました。
 * ありがとうございます。
 * 
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.system.Security;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    
    
    [SWF(width = 465, height = 465, frameRate = 30, backgroundColor = 0x000000)]
    public class Main extends Sprite
    {
        // 定数
        private const FFT_MODE    :Boolean = false;
        private const COLOR        :Array = [0xFF0000, 0xFFFF00, 0x990000, 0x999900];
        // 変数
        private var _sp            :Sprite;
        private var _sp2            :Sprite;
        private var _bmp:Bitmap;
        private var _bmpd:BitmapData;
        
        // constructor
        public function Main():void {
            stage.frameRate = 30;
            
            _bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            _bmp = new Bitmap(_bmpd);
            
            
            _sp2 = new Sprite();
            _sp2.x = -stage.stageWidth / 2;
            _sp2.y = -stage.stageHeight / 2;
            _sp2.scaleX = 2.0;
            _sp2.scaleY = 2.0;
            _sp2.alpha = 0.5;
            
            _sp2.addChild(_bmp); 
            this.addChild(_sp2);
            
            _sp = new Sprite();
            _sp.x = stage.stageWidth / 2;
            _sp.y = stage.stageHeight / 2;
            this.addChild(_sp);
            
            
            // mp3
            var snd:Sound = new Sound();
            Security.loadPolicyFile("http://mutast.heteml.jp/crossdomain.xml");
            var req:URLRequest = new URLRequest("http://vaindog.raindrop.jp/wonderfl/sound/bgm_maoudamashii_cyber06.mp3");
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            snd.load(req, context);
            
            var channel:SoundChannel = snd.play();
            var transform:SoundTransform = new SoundTransform();
            transform.volume = 0.5;    // ボリュームを半分に
            transform.pan = 0.0;    // パンは中央
            channel.soundTransform = transform;
            // 再生終了時
            channel.addEventListener(Event.SOUND_COMPLETE, onPlaybackComplete);
            
            // フレーム処理
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // 再生終了時
        private function onPlaybackComplete(event:Event):void {
            this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            _sp.graphics.clear();
        }
        
        // フレーム処理
        private function onEnterFrame(event:Event):void {
            var bytes:ByteArray = new ByteArray();
            const CHANNEL_LENGTH:int = 256;
            const R:int = 200;
            const OFFSET:int = 100;
            
            var color:uint;
            var i:int;
            var index:uint;
            var n:Number;
            var rad:Number;
            var point:Point = new Point();
            var point0:Point = new Point();
            var point1:Point = new Point();
            var point2:Point = new Point();
            var point3:Point = new Point();
            
            var g:Graphics = _sp.graphics;
            g.clear();
            
            SoundMixer.computeSpectrum(bytes, FFT_MODE, 0);
            
            // L
            index = 0;
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                n = bytes.readFloat() * R + OFFSET;
                
                if (i % 8 != 0) continue;
                
                color = n >= OFFSET ? COLOR[index] : COLOR[index + 2];
                g.lineStyle(1, color);
                g.beginFill(color, 0.5);
                
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) - deg2rad(360 / CHANNEL_LENGTH) + index * deg2rad(180);
                point0 = new Point(OFFSET * Math.cos(rad), OFFSET * Math.sin(rad));
                point1 = new Point(n * Math.cos(rad), n * Math.sin(rad));
                
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) + deg2rad(360 / CHANNEL_LENGTH) + index * deg2rad(180);
                point3 = new Point(OFFSET * Math.cos(rad), OFFSET * Math.sin(rad));
                point2 = new Point(n * Math.cos(rad), n * Math.sin(rad));
                
                g.moveTo(point0.x, point0.y);
                g.lineTo(point1.x, point1.y);
                g.lineTo(point2.x, point2.y);
                g.lineTo(point3.x, point3.y);
                g.lineTo(point0.x, point0.y);
                
                g.endFill();
            }
            
            // R
            index = 1;
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                n = bytes.readFloat() * R + OFFSET;
                
                if (i % 8 != 0) continue;
                
                color = n >= OFFSET ? COLOR[index] : COLOR[index + 2];
                g.lineStyle(1, color);
                g.beginFill(color, 0.5);
                
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) - deg2rad(360 / CHANNEL_LENGTH) + index * deg2rad(180);
                point0 = new Point(OFFSET * Math.cos(rad), OFFSET * Math.sin(rad));
                point1 = new Point(n * Math.cos(rad), n * Math.sin(rad));
                
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) + deg2rad(360 / CHANNEL_LENGTH) + index * deg2rad(180);
                point3 = new Point(OFFSET * Math.cos(rad), OFFSET * Math.sin(rad));
                point2 = new Point(n * Math.cos(rad), n * Math.sin(rad));
                
                g.moveTo(point0.x, point0.y);
                g.lineTo(point1.x, point1.y);
                g.lineTo(point2.x, point2.y);
                g.lineTo(point3.x, point3.y);
                g.lineTo(point0.x, point0.y);
                
                g.endFill();
            }
            
            _sp2.visible = false;
            _bmpd.fillRect(_bmpd.rect, 0x000000);
            _bmpd.draw(stage);
            _sp2.visible = true;
        }
        
        // degree -> radian
        private function deg2rad(deg:Number):Number {
            deg %= 360;
            return deg / 180 * Math.PI;
        }
    }
}