/**
 * Copyright kikiroom ( http://wonderfl.net/user/kikiroom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qHAK
 */

// forked from Aquioux's 色相環と setPixel による平面の塗りつぶしパターン
package {
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import frocessing.color.ColorHSV;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
    /**
     * 色相環と setPixel による平面の塗りつぶしパターン
     * @author Aquioux(YOSHIDA, Akio)
     */
    public class Main extends Sprite {
        private const W:int = 360;
        private const H:int = 360;
        private const HALF_W:int = W / 2;
        private const HALF_H:int = H / 2;
        
        private var hsv_:ColorHSV = new ColorHSV();
        private var bmd_:BitmapData;
        private var label1_:Label;
        private var label2_:Label;

        private var funcs_:Array;
        private var flg_:int = 0;
        
        public function Main():void {
            // 変数定義
            var offsetX:int = (stage.stageWidth - W)  / 2;
            var offsetY:int = 35;// (stage.stageHeight - H) / 2;
            
            // BitmapData
            bmd_ = new BitmapData(W, H, false, 0x0);
            var bm:Bitmap = new Bitmap(bmd_);
            bm.x = offsetX;
            bm.y = offsetY;
            addChild(bm);
            
            // 説明文
            label1_ = new Label(this, offsetX, 0, "Fill Rectangle Area defined\nW (width) = 360, H (height) = 360, HALF_W = 180, HALF_H = 180");
            label2_ = new Label(this, offsetX, offsetY + H);
            
            // 切り替えボタン
            var buttonWidth:int = 50;
            var button:PushButton = new PushButton(this, offsetX + W - buttonWidth, offsetY + H, "Change", buttonHandler);
            button.width = buttonWidth;
            
            // 塗りつぶしパターンを配列に格納
            funcs_ = [
                pattern11, pattern12, pattern13, pattern14,
                pattern21, pattern22, pattern23, pattern24,
                pattern31, pattern32, pattern33, pattern34,
                pattern41, pattern42, pattern43,
                pattern51, pattern52,
                pattern61, pattern62,
                pattern71, pattern72,
                pattern81, pattern82,
                pattern91, pattern92
            ];
            
            // 最初の処理
            buttonHandler(null);
        }
        
        // ボタンハンドラ
        private function buttonHandler(e:Event):void {
            funcs_[flg_]();
            flg_++;
            flg_ = flg_ % funcs_.length;
        }
        
        // 塗りつぶしパターン
        // 横方向（左から右）
        private function pattern11():void {
            label2_.text = "hsv.h = x";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = x;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 横方向（右から左）
        private function pattern12():void {
            label2_.text = "hsv.h = -x";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = -x;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 横方向（左右から中央）
        private function pattern13():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nhsv_.h = Math.abs(x - offsetX) * (360 / 180);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    hsv_.h = Math.abs(x - offsetX) * (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 横方向（中央から左右）
        private function pattern14():void {
            label2_.text = "var offsetX:int = (x < HALF_W) ? W : 0;\nhsv_.h = Math.abs(x - offsetX) * (360 / 180);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x < HALF_W) ? W : 0;
                    hsv_.h = Math.abs(x - offsetX) * (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        // 縦方向（上から下）
        private function pattern21():void {
            label2_.text = "hsv.h = y";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = y;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 縦方向（下から上）
        private function pattern22():void {
            label2_.text = "hsv.h = -y";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = -y;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 縦方向（上下から中央）
        private function pattern23():void {
            label2_.text = "var offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(y - offsetY) * (360 / 180);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(y - offsetY) * (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 横方向（中央から上下）
        private function pattern24():void {
            label2_.text = "var offsetY:int = (y < HALF_H) ? H : 0;\nhsv_.h = Math.abs(y - offsetY) * (360 / 180);"
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetY:int = (y < HALF_H) ? H : 0;
                    hsv_.h = Math.abs(y - offsetY) * (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        // 斜め（左上から右下）
        private function pattern31():void {
            label2_.text = "hsv_.h = (x + y) / (360 / 180);\nbmd_.setPixel(x, y, hsv_.value);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (x + y) / (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 斜め（右下から左上）
        private function pattern32():void {
            label2_.text = "hsv_.h = (-x - y) / (360 / 180);\nbmd_.setPixel(x, y, hsv_.value);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (-x - y) / (360 / 180);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 斜め（右上から左下）
        private function pattern33():void {
            label2_.text = "hsv_.h = ( -x + y) / (360 / 180) + 180;\nbmd_.setPixel(x, y, hsv_.value);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = ( -x + y) / (360 / 180) + 180;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 斜め（左下から右上）
        private function pattern34():void {
            label2_.text = "hsv_.h = (x - y) / (360 / 180) + 180;\nbmd_.setPixel(x, y, hsv_.value);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (x - y) / (360 / 180) + 180;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }

        // 菱形（四隅から中央）
        private function pattern41():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 菱形（中央から四隅）
        private function pattern42():void {
            label2_.text = "var offsetX:int = (x < HALF_W) ? W : 0;\nvar offsetY:int = (y < HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x < HALF_W) ? W : 0;
                    var offsetY:int = (y < HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 円（周縁から中央へ）
        private function pattern43():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) * Math.abs(y - offsetY) / 90;";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) * Math.abs(y - offsetY) / 90;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        // X字状1
        private function pattern51():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y < HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y < HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // X字状2
        private function pattern52():void {
            label2_.text = "var offsetX:int = (x < HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x < HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) + Math.abs(y - offsetY);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        // 十字状（中央から）
        private function pattern61():void {
            label2_.text = "hsv_.h = ((x - HALF_W) * (y - HALF_H)) / 180;\nbmd_.setPixel(x, y, hsv_.value);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = ((x - HALF_W) * (y - HALF_H)) / 180;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 十字状（中央へ）
        private function pattern62():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nvar x2:int = x - offsetX;\nvar y2:int = y - offsetY;\nhsv_.h = (x2 * x2 + y2 * y2) / 180;";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    var x2:int = x - offsetX;
                    var y2:int = y - offsetY;
                    hsv_.h = (x2 * x2 + y2 * y2) / 180;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }

        // 
        private function pattern71():void {
            label2_.text = "hsv_.h = (x * y) / 360;";

            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (x * y) / 360;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        // 
        private function pattern72():void {
            label2_.text = "hsv_.h = (x * x + y * y) / (x + y);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (x * x + y * y) / (x + y);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        //
        private function pattern81():void {
            label2_.text = "hsv_.h = (x * x) / (x + y);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (x * x) / (x + y);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        //
        private function pattern82():void {
            label2_.text = "hsv_.h = (y * y) / (x + y);";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    hsv_.h = (y * y) / (x + y);
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
        private function pattern91():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(x - offsetX) / Math.abs(y - offsetY) * 360;";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(x - offsetX) / Math.abs(y - offsetY) * 360;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        private function pattern92():void {
            label2_.text = "var offsetX:int = (x > HALF_W) ? W : 0;\nvar offsetY:int = (y > HALF_H) ? H : 0;\nhsv_.h = Math.abs(y - offsetY) / Math.abs(x - offsetX) * 360;";
            bmd_.lock();
            for (var y:int = 0; y < H; y++) {
                for (var x:int = 0; x < W; x++) {
                    var offsetX:int = (x > HALF_W) ? W : 0;
                    var offsetY:int = (y > HALF_H) ? H : 0;
                    hsv_.h = Math.abs(y - offsetY) / Math.abs(x - offsetX) * 360;
                    bmd_.setPixel(x, y, hsv_.value);
                }
            }
            bmd_.unlock();
        }
        
    }
    
}