/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qGjA
 */

package
{
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.Security;
	
	public class Fractal extends Sprite
	{
		private static const WIDTH:Number = 465;
		private static const HEIGHT:Number = 465
		private static const IMAGE_PATH:String = "http://yanbaka.com/wonderfl/kote.jpg";
		private var _image:Bitmap;
		
		private var sizeList:Array = [31, 93, 155];
		private var rectList:Array = [];
		private var imageList:Array = [];
		
		public function Fractal()
		{
			load();
		}
		
		private function load():void
		{
			Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
			 
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			loader.load(new URLRequest("http://5ivestar.org/proxy/"+IMAGE_PATH));
		}
		
		private function onComplete(e:Event):void
		{
			_image = Bitmap(e.target.loader.content);
			
			start();
			
			stage.addEventListener(MouseEvent.CLICK, function():void
			{
				reset();
			});
		}
		
		public function reset():void
		{
			Tweener.removeAllTweens();
			var i:int = imageList.length;
			while(i--)
			{
				var image:Bitmap = imageList[i];
				removeChild(image);
				image = null;
			}
			rectList = [];
			imageList = [];
			
			start();
		}
		
		private function start():void
		{
			add(new Rectangle(0, 0, WIDTH, HEIGHT));
			put();
		}
		
		private function put():void
		{
			var i:int = rectList.length;
			while(i--)
			{
				var rect:Rectangle = rectList[i];
				var image:Bitmap = imageList[i];
				image.bitmapData = _image.bitmapData;
				image.smoothing = true;
				image.x = rect.x;
				image.y = rect.y;
				image.width = rect.width;
				image.height = rect.height;
				image.y = 0;
//				image.y = rect.y -5;
				
				image.alpha = 0.0;
				Tweener.addTween(image, {delay:i*0.05, alpha:1.0, y:rect.y, time:0.5});
			}
		}
		
		private function add(base:Rectangle):void
		{
			var temp1:Rectangle;
			var temp2:Rectangle;
			var size:int = sizeList[getSize(base)];
			
			// 残りの空白
			var r:int = getRandom(8);
			var rx:int;
			var ry:int;
			switch(r)
			{
				case 0:
				// 左上（横）
				temp1 = new Rectangle(base.x+size, base.y+0, base.width-size, size);
				temp2 = new Rectangle(base.x+0, base.y+size, base.width-0, base.height-size);
				rx = base.x+0;
				ry = base.y+0;
				break;
				
				case 1:
				// 右上（横）
				temp1 = new Rectangle(base.x+0, base.y+0, base.width-size, size);
				temp2 = new Rectangle(base.x+0, base.y+size, base.width-0, base.height-size);
				rx = base.x+base.width-size;
				ry = base.y+0;
				break;
				
				case 2:
				// 左下（横）
				temp1 = new Rectangle(base.x+0, base.y+0, base.width, base.height-size);
				temp2 = new Rectangle(base.x+size, base.y+base.height-size, base.width-size, size);
				rx = base.x+0;
				ry = base.y+base.height-size;
				break;
				
				case 3:
				// 右下（横）
				temp1 = new Rectangle(base.x+0, base.y+0, base.width, base.height-size);
				temp2 = new Rectangle(base.x+0, base.y+base.height-size, base.width-size, size);
				rx = base.x+base.width-size;
				ry = base.y+base.height-size;
				break;
				
				case 4:
				// 左上（縦）
				temp1 = new Rectangle(base.x+0, base.y+size, size, base.height-size);
				temp2 = new Rectangle(base.x+size, base.y+0, base.width-size, base.height-0);
				rx = base.x+0;
				ry = base.y+0;
				break;
				
				case 5:
				// 右上（縦）
				temp1 = new Rectangle(base.x+base.width-size, base.y+size, size, base.height-size);
				temp2 = new Rectangle(base.x+0, base.y+0, base.width-size, base.height-0);
				rx = base.x+base.width-size;
				ry = base.y+0;
				break;
				
				case 6:
				// 左下（縦）
				temp1 = new Rectangle(base.x+0, base.y+0, size, base.height-size);
				temp2 = new Rectangle(base.x+size, base.y+0, base.width-size, base.height);
				rx = base.x+0;
				ry = base.y+base.height-size;
				break;
				
				case 7:
				// 右下（縦）
				temp1 = new Rectangle(base.x+base.width-size, base.y+0, size, base.height-size);
				temp2 = new Rectangle(base.x+0, base.y+0, base.width-size, base.height);
				rx = base.x+base.width-size;
				ry = base.y+base.height-size;
				break;
				
				default:
				break;
			}
			
			// 生成
			var rect:Rectangle = new Rectangle(rx, ry, size, size);
			rectList.push(rect);
			var image:Bitmap = new Bitmap();
			imageList.push(image);
			addChild(image);
			
			// 再帰
			if(temp1.width > 0 && temp1.height > 0)
			{
				add(temp1);
			}
			
			if(temp2.width > 0 && temp2.height > 0)
			{
				add(temp2);
			}
		}
		
		private function getSize(rect:Rectangle):int
		{
			var result:int;
			
			var min:int;
			(rect.width > rect.height)? min = rect.height : min = rect.width;
			
			if(min < sizeList[1])
			{
				result = 0;
			}
			else if(min < sizeList[2])
			{
				result = getRandom(2);
			}
			else
			{
				result = getRandom(3);
			}
			
			return result;
		}
		
		private function getRandom(value:int):int
		{
			return Math.random()*value >> 0;
		}
	}
}