/**
 * Copyright Ricki_G ( http://wonderfl.net/user/Ricki_G )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qGJo
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;

	[SWF( width="512", height = "512", backgroundColor = "0x222222", frameRate = "120" )]
	
	public class ParticlesBitmap extends Sprite
	{
		private static const AMOUNT:int = 1000;
		private static var fading : ColorTransform = new ColorTransform( 1, 1, 1, 0.95 );
		private static var blur : BlurFilter = new BlurFilter( 0, 0, 1 );
		
		private var _bmd:BitmapData;
		private var _bmp:Bitmap;
		private var _particles:Vector.<particle>;
		
		public function ParticlesBitmap()
		{			
			_bmd = new BitmapData(512, 512, false, 0x222222);
			_bmp = new Bitmap(_bmd);
			_particles = new Vector.<particle>();
			addChild(_bmp);
addChild( new Stats( { bg: 0xFF6600, fps: 0x222222, ms: 0x505050, mem: 0x707070, memmax: 0x000000 } ) );
			addEventListener(Event.ENTER_FRAME, update, false, 0, true);
			
			var p:particle;
			
			for(var i:int = 0; i < AMOUNT; i++)
			{
				p = new particle();
				p.vx = randNum(-1, 1);
				p.vy = randNum(-1, 1);
				p.x = randNum(0, width);
				p.y = randNum(0, height);
				_bmd.setPixel(p.x, p.y, 0xFF6600);
				_particles.push(p);
			}
		}
		
		private function update(event:Event):void
		{	
			var p:particle;
			for(var i:int = 0; i < AMOUNT; i++)
			{
				p = _particles[i]
				p.x += randNum(-2, 2) * p.vx;
				p.y += randNum(-2, 2) * p.vy;
				if(p.x > width) p.x = 0;
				if(p.x < 0) p.x = width;
				if(p.y > height) p.y = 0;
				if(p.y < 0) p.y = height;				
				_bmd.setPixel(p.x, p.y, 0xFF6600);
			}			
				_bmd.colorTransform( _bmd.rect, fading );
				_bmp.filters = [blur];
		}
		private function randNum(min:Number, max:Number):Number
		{
			return Math.random()*(max-min)+min;
		}		
	}
}

class particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
}