/**
 * Copyright paranoio ( http://wonderfl.net/user/paranoio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qFZB
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    /**
    * motion.com.mx
    */
    [SWF(width = "465", height = "465", backgroundColor = "0x111111", frameRate = "60")]
    public class DepthTest extends Sprite {
        private var layers:Array;
        private var	totalDepths:Number;
        public function DepthTest() {
           	totalDepths = 50;
			createObjects();		
			addEventListener(Event.ENTER_FRAME , enterframe );
            
        }
        
		private function createObjects():void {
			layers = [];
			var layer:Sprite;
			for (var i:int = 0; i < totalDepths; i++) {
				layer = new Sprite()
				layer.graphics.lineStyle( 1, 0xFFFFFF)
				layer.graphics.beginFill ( 0x23C56B )
				layer.graphics.drawEllipse( 0, 0, 200, totalDepths )
				layer.graphics.endFill();
				
				layer.alpha = 1- 1/ totalDepths * i
				layer.x = stage.stageWidth / 2 ;
				layer.y = stage.stageHeight/2
				layer.scaleX = layer.scaleY =  1 / totalDepths * i;
				layer.rotation = 360 / totalDepths *i;
				layer.blendMode = "add";
				addChild( layer );
				layers[i] = layer;
			}
		}
		private function enterframe(e:Event):void {
			var midx:Number   = stage.stageWidth / 2 ;
			var midy:Number   = stage.stageHeight / 2 ;
			var mousex:Number = mouseX - midx ;
			var mousey:Number = mouseY - midy ;
			
			for (var i:int = 0; i < layers.length; i++) {
				layers[i].x = midx + layers[i].scaleX * mousex;
				layers[i].y = midy + layers[i].scaleY * mousey;
				layers[i].rotation = 360 *  i / totalDepths;
				
			}
		}
    }
}