/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qFXg
 */

package {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.errors.EOFError;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
    import flash.display.Sprite;
	import flash.text.TextField;
	
    public class CellularAutomata extends Sprite {

		private var imgWidth:int = 400;
		private var imgHeight:int = 400;
		private var bmd:BitmapData = new BitmapData(imgWidth, imgHeight, true, 0xFFFFFFFF);
		private var bm:Bitmap = new Bitmap(bmd);
		private var rect:Rectangle = new Rectangle(0, 0, imgWidth, imgHeight);
		private var bytes:ByteArray = bmd.getPixels(rect);
		
        public function CellularAutomata() {
			
			addChild(bm);
			bytes.position = 0;
			//identity
			bmd.setPixels(rect, bytes);
			//watch size of bytearray
			var tf:TextField = new TextField();
			tf.text = "" + bytes.length;
			addChild(tf);

			writeRandomBytes();
        }

		private function writeRandomBytes():void
		{	
			//re-init the bytearray
			bytes = new ByteArray;
			bytes.position = 0;
			var col:int = 0
			var row:int = 0;
			var rowLength:int = col*4;//4 bytes per pixel 32-bit
				
			try {
				while(bytes.position < imgWidth*4*imgHeight)
				{
					bytes.position += 4;
					bytes.writeUnsignedInt(Math.random()*0xFFFFFFFF);
				}
			}
			catch(e:EOFError) {
				//trace(e);
			}
			bmd.setPixels(rect, bytes);
		}
    }
}
