/**
 * Copyright naonya3 ( http://wonderfl.net/user/naonya3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qFOc
 */

//ダイヤル的な物
//数学わかりませんまさお
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFormat;
	[SWF(backgroundColor="#FFFFFF", frameRate=30)]
	public class Main extends Sprite {
		
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			var t:TextField = new TextField();
			t.defaultTextFormat = new TextFormat(null, 30);
			var c:CircleUI = new CircleUI();
			c.addEventListener('update', function():void {
				t.text = Math.round(c.count).toString();
			});
			addChild(c);
			addChild(t);
		}
	}
}

	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	class CircleUI extends Sprite {
		
		private var _dial:Shape = new Shape();
		private static const _windowWidth:Number = 480;
		private static const _windowHeight:Number = 480;
		
		public function CircleUI() {
			this.graphics.beginBitmapFill(new BitmapData(_windowWidth, _windowHeight));
			this.graphics.drawRect(0, 0, _windowWidth, _windowHeight);
			
			_dial.graphics.beginFill(0x000000, 1);
			_dial.graphics.drawCircle(0, 0, 100);
			_dial.graphics.drawCircle(0, 0, 99);
			_dial.graphics.endFill();
			_dial.graphics.beginFill(0x000000, 1);
			_dial.graphics.lineStyle(1);
			_dial.graphics.moveTo(85,0);
			_dial.graphics.lineTo(100, 0);
			_dial.graphics.endFill();
			addChild(_dial);
			_dial.x = _windowWidth / 2;
			_dial.y = _windowHeight / 2;
			
			this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		
		private function mouseDownHandler(e:MouseEvent):void {
			addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		
		private function mouseUpHandler(e:MouseEvent):void {
			removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		
		private function mouseMoveHandler(e:MouseEvent):void {
			check(e.stageX,e.stageY);
		}
		
		private var dx:Number = 0;
		private var dy:Number = 0;
		private var dis:Number = 0;
		private var rad:Number = 0;
		private var deg:Number = 0;
		private var lastDeg:Number = 0;
		private var nowDeg:Number = 0;
		private var allDeg:Number = 0;
		
		private function check(mx:Number, my:Number):void{			
			dx = _windowWidth / 2 - mx;
			dy = _windowHeight / 2 - my;
			dy = -dy;
			dis = Math.sqrt(dx * dx + dy * dy);
			rad = Math.atan2(dy, dx);
			deg = 180 - 180 * rad / Math.PI;
			if (-50 < deg - lastDeg && 200 > deg - lastDeg && dis > 50) {
				allDeg += deg  - lastDeg;
				_dial.rotation = deg;
			}
			lastDeg = deg;
			
			dispatchEvent(new Event('update'));
		}
		
		public function get count():Number {
			return allDeg / 360;
		}
		
	}
