/**
 * Copyright TylerS ( http://wonderfl.net/user/TylerS )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qF6M
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import gs.TweenLite;
    import gs.easing.*;
    import flash.filters.GlowFilter;
    
    [SWF(backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        
        private var circle1:Sprite;
        private var circle2:Sprite;
        
        public function FlashTest() {
            // write as3 code here..
            createObjects();    
        }
        
        
        public function createObjects():void {
			circle1 = createCircle(50,50,0x180CFF,1,20);
			var glowFilter:GlowFilter = new GlowFilter(
			   0x00FF00, .5, 25, 25, 3);
			circle1.filters = [glowFilter];
			
			circle2 = createCircle(455,50,0x180CFF,1,20);
			circle2.filters = [glowFilter];
			
			var glowFilter2:GlowFilter = new GlowFilter(
			   0xFFFFFF, .6, 10, 10, 4, 3);
			var bag:Sprite = createBag(225,200, 0xCC16FF, .3, 50, 75);
			bag.filters = [glowFilter2];
        }
        
        public function createBag(x:Number, y:Number, 
            color:uint, alpha:Number, width:Number, height:Number):Sprite {
            
            var theBag:Sprite = new Sprite();
            addChild(theBag);
            theBag.graphics.clear();
            //theBag.graphics.lineStyle(2,0xFFFFFF,alpha);
            theBag.graphics.beginFill(color,alpha);
            theBag.graphics.drawRoundRect(0,0,width, height,8,8);
            theBag.graphics.endFill();
            theBag.x = x;
            theBag.y = y;
            theBag.addEventListener("click", onClickBag);
            return theBag;
        }
        
        public function createCircle(x:Number, y:Number, 
            color:uint, alpha:Number, radius:Number):Sprite {
            
            var theNewCircle:Sprite = new Sprite();
            addChild(theNewCircle);
            theNewCircle.graphics.clear();
            theNewCircle.graphics.beginFill(color,alpha);
            theNewCircle.graphics.drawCircle(-radius,-radius,radius);
            theNewCircle.graphics.endFill();
            theNewCircle.addEventListener("click", onClick);
            theNewCircle.x = x;
            theNewCircle.y = y;
            return theNewCircle;
        }
        
        public function onClick(e:MouseEvent):void {
            TweenLite.to(e.target, 1, {x:270, y:250, ease:Bounce.easeOut});
        } 
        
         public function onClickBag(e:MouseEvent):void {
            TweenLite.to(circle1, 1, {x:50, y:50, ease:Bounce.easeOut});   	
            TweenLite.to(circle2, 1, {x:455, y:50, ease:Bounce.easeOut});   	
         }
    }
    
}