/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qF4A
 */

package {
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var bitmap:BitmapData = new BitmapData(465, 465);
        private var rect:Rectangle;
        private var unkos:Vector.<Unko> = new Vector.<Unko>;

        public function FlashTest() {
            addChild(new Bitmap(bitmap));
            rect = bitmap.rect;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, function ():void {
                Wonderfl.log('yes!unky!');
                var unko:Unko = new Unko();
                unko.x = stage.mouseX;
                unko.y = stage.mouseY;
                unkos.push(unko);
                Wonderfl.log(unkos[0].x, unkos[0].y);
            });

        }
        
        private function onEnterFrame(event:Event):void {
            bitmap.lock();
            bitmap.fillRect(rect, 0xFFFFFF);
            var length:int = unkos.length;
            var unko:Unko, unko2:Unko;
            var i:uint, j:uint;
            var dX:int, dY:int, sX:int, sY:int, E:int;

            for (i = 0; i < length; i++) {
                unko = unkos[i];
                
                for (j = 0; j < length; j++) {
                    unko2 = unkos[j];
                    
                    if (unko2 == unko) continue;

                    dX = (unko2.x > x) ? unko2.x - unko.x : unko.x - unko2.x;
                    dY = (unko2.y > y) ? unko2.y - unko.y : unko.y - unko2.y;

                    sX = (unko2.x > unko.x) ? 1 : -1;
                    sY = (unko2.y > unko.y) ? 1 : -1;

                    if (dX > dY) {
                        E = - dX;
                        unko.speedX += sX;
                        E += 2 * dY;
                        if (E >= 0) {
                            unko.speedY += sY;
                        }
                    } else {
                        E = - dY;
                        unko.speedY += sY;
                        E += 2 * dX;
                        if (E >= 0) {
                            unko.speedX += sX;
                            E -= 2 * dY;
                        }
                    }
                }

                unko.x += unko.speedX;
                unko.y += unko.speedY;

                bitmap.setPixel(unko.x, unko.y, 0x000000);
            }
            
            bitmap.unlock();
        }

    }
}

class Unko {
    public var speedX:Number = 0;
    public var speedY:Number = 0;
    public var gravity:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
}
