/**
 * Copyright mikako ( http://wonderfl.net/user/mikako )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qE7S
 */

// forked from PESakaTFM's forked from: flash on 2010-3-1
// forked from hosaka893's flash on 2010-3-1
package {
    import flash.display.Sprite;
	import flash.display.Graphics;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
    		public var rot:Number = 0;
    		
        public function FlashTest() {
            // write as3 code here..
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        public function onEnter(event:Event):void
        {
        		rot += .02;
        	    
        		graphics.clear();
            graphics.lineStyle(1,0);
            graphics.beginFill(0xFFFF00,1);
            drawStar(graphics, 100, 100, 50, 20, rot);
            drawPentagram(graphics, 300, 200, 50, -rot);
            graphics.endFill();
        }
		
		/**
		 *  @public
		 *  Draws a pentagram (without the circle).
		 *
		 *  @param g		The Graphics object you want to draw to.
		 *  @param _x	The x value of the center
		 *  @param _y	The y value of the center
		 *  @param r		The radius of the circle which we use make an even pentagram
		 *  @param rot	The rotation in radians
		 **/
		public function drawPentagram(g:Graphics, _x:Number=0, _y:Number=0, r:Number=50, rot:Number=0):void
		{
			var angle:Number = rot+Math.PI/2;
			var px:Number = _x+Math.cos(angle)*r;
			var py:Number = _y+Math.sin(angle)*r;
			
			g.moveTo(px,py);
			for(var i:int=0; i<5; i++)
			{
				angle += 4*Math.PI/5;
				px = _x+Math.cos(angle)*r;
				py = _y+Math.sin(angle)*r;
				g.lineTo(px,py);
			}
		}
		
		/**
		 *  @public
		 *  Draws a star shape.
		 *
		 *  @param g			The Graphics object you want to draw to.
		 *  @param _x		The x value of the center
		 *  @param _y		The y value of the center
		 *  @param outer		The distance of the outer points from center
		 *  @param inner		The distance of the inner points from center
		 *  @param rot		The rotation in radians
		 **/
		public function drawStar(g:Graphics, _x:Number=0, _y:Number=0, outer:Number=50, inner:Number=20, rot:Number=0):void
		{
			var angle:Number = rot+Math.PI/2;
			var px:Number = _x+Math.cos(angle)*outer;
			var py:Number = _y+Math.sin(angle)*outer;
			
			g.moveTo(px,py);
			for(var i:int=0; i<5; i++)
			{
				angle += Math.PI/5;
				px = _x+Math.cos(angle)*inner;
				py = _y+Math.sin(angle)*inner;
				g.lineTo(px,py);
				
				angle += Math.PI/5;
				px = _x+Math.cos(angle)*outer;
				py = _y+Math.sin(angle)*outer;
				g.lineTo(px,py);
			}
		}
    }
}