/**
 * Copyright noli ( http://wonderfl.net/user/noli )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qDqP
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.getTimer;
    public class FlashTest extends Sprite
    {
        private var oldTime:Number = 0;
        private var num:int = 10000000;
        private var textField:TextField = new TextField();
        
        public function FlashTest()
        {
            textField.width = 465;
            textField.height = 465;
            this.addChild(textField);
            
            textField.appendText("【Math.floor｜小数点以下切り捨て】\n");
            test1();
            test2();
            textField.appendText("\n【Math.ceil｜小数点以下切り上げ】\n");
            test3();
            test4();
            textField.appendText("\n【Math.max｜最大値】\n");
            test5();
            test6();
            textField.appendText("\n【Math.min｜最小値】\n");
            test7();
            test8();
            textField.appendText("\n【Math.abs｜絶対値】\n");
            test9();
            test10();
        }
        
        public function test1():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = int(Math.random() * 1000);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ intでくくった：" + takenTime + "\n"));
        }
        
        public function test2():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = Math.floor(Math.random() * 1000);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ Math.floorを使用：" + takenTime + "\n"));
        }
        
        public function test3():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = Math.random() * 1000;
                temp = (temp == int(temp))? temp : int(temp + 1);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ intでくくった：" + takenTime + "\n"));
        }
        
        public function test4():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = Math.random() * 1000;
                temp = Math.ceil(temp);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ Math.ceilを使用：" + takenTime + "\n"));
        }
        
        public function test5():void
        {
            var temp:Number;
            var temp1:Number;
            var temp2:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp1 = Math.random() * 1000;
                temp2 = Math.random() * 1000;
                temp = (temp1 > temp2)? temp1 : temp2;
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ 条件演算子を使用：" + takenTime + "\n"));
        }
        
        public function test6():void
        {
            var temp:Number;
            var temp1:Number;
            var temp2:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp1 = Math.random() * 1000;
                temp2 = Math.random() * 1000;
                temp = Math.max(temp1, temp2);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ Math.maxを使用：" + takenTime + "\n"));
        }
        
        public function test7():void
        {
            var temp:Number;
            var temp1:Number;
            var temp2:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp1 = Math.random() * 1000;
                temp2 = Math.random() * 1000;
                temp = (temp1 > temp2)? temp2 : temp1;
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ 条件演算子を使用：" + takenTime + "\n"));
        }
        
        public function test8():void
        {
            var temp:Number;
            var temp1:Number;
            var temp2:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp1 = Math.random() * 1000;
                temp2 = Math.random() * 1000;
                temp = Math.min(temp1, temp2);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ Math.minを使用：" + takenTime + "\n"));
        }
        
        public function test9():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = Math.random() * -2000 + 1000;
                temp = (temp > 0)? temp : -temp;
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ 条件演算子を使用：" + takenTime + "\n"));
        }
        
        public function test10():void
        {
            var temp:Number;
            oldTime = getTimer();
            for(var i:int = 0; i < num; i ++)
            {
                temp = Math.random() * -2000 + 1000;
                temp = Math.abs(temp);
            }
            var takenTime:Number = getTimer() - oldTime;
            textField.appendText(String("■ Math.absを使用：" + takenTime + "\n"));
        }
    }
}