/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qDkI
 */

package {
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var ball:Ball;
        private var line:Sprite;
        private var gravity:Number = 0.3;
        private var bounce:Number = -0.6;
        
        public function FlashTest() {
            // write as3 code here..
            ball = new Ball();
            addChild(ball);
            ball.x = 150;
            ball.y = 150;
            
            line = new Sprite();
            line.graphics.lineStyle(1);
            line.graphics.lineTo(300, 0);
            addChild(line);
            line.x = 50;
            line.y = 200;
            line.rotation = 30;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(e:Event):void
        {
            line.rotation = (stage.stageWidth / 2 - mouseX) * 0.1;
            ball.vy += gravity;
            ball.x += ball.vx;
            ball.y += ball.vy;
            
            var angle:Number = line.rotation * Math.PI / 180;
            var cos:Number = Math.cos(angle);
            var sin:Number = Math.sin(angle);
            
            var x1:Number = ball.x - line.x;
            var y1:Number = ball.y - line.y;
            
            var y2:Number = cos * y1 - sin * x1;
            
            
            var bounds:Rectangle = line.getBounds(this);
            if(ball.x > bounds.left && ball.x < bounds.right)
            {
                var x2:Number = cos * x1 + sin * y1;
                
                var vx1:Number = cos * ball.vx + sin * ball.vy;
                var vy1:Number = cos * ball.vy - sin * ball.vx;
            
                y2 = -ball.height / 2;
                vy1 *= bounce;
                
                x1 = cos * x2 - sin * y2;
                y1 = cos * y2 + sin * x2;
                ball.vx = cos * vx1 - sin * vy1;
                ball.vy = cos * vy1 + sin * vx1;
                ball.x = line.x + x1;
                ball.y = line.y + y1;
            }
            
            
        }

    }
}
import flash.display.Sprite;

class Ball extends Sprite
{
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Ball()
    {
        graphics.beginFill(0xFF0000);
        graphics.drawCircle(0, 0, 30);
        graphics.endFill();
    }

}
