/**
 * Copyright k.cherenkov ( http://wonderfl.net/user/k.cherenkov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qCvm
 */

package {
    import flash.geom.Point;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.display.Scene;
    import flash.display.Graphics;
    import flash.display.Sprite;
    
    public class SnakeGame extends Sprite {
        private static var matrix : Array;
        private const mwidth : int = 20;
        private const mheight : int = 20;
        private var x0 : int = 10;
        private var y0 : int = 10;
        private var x1 : int = stage.stageWidth - 10;
        private var y1 : int = stage.stageHeight - 10;
        private var stepH:Number = (y1-10)/mheight;
        private var stepW:Number = (x1-x0)/mwidth;
        
        public function DrawSnake(snake : Snake, newHead : Point) : void
        {
            graphics.beginFill(0x0000FF);
            var oldTail : ListElement = snake.Tail;
            snake.DoMove(newHead);
            graphics.drawRect(x0 + newHead.x*stepW, y0 + newHead.y*stepH, stepW, stepH);
            graphics.endFill();
            
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(x0 + oldTail.Data.x*stepW, y0 + oldTail.Data.y*stepH, stepW, stepH);
            graphics.endFill();
        }

        
        public function SnakeGame() {
            matrix = new Array(mwidth * mheight);
            
            graphics.lineStyle(1, 0xFF0000);
            graphics.drawRect(x0, y0, x1 -10, y1 - 10);
            
            for (var i : Number = y0; i < y1; i = i+stepH)
            {
                graphics.moveTo(x0, i);
                graphics.lineTo(x1, i);
            }
            
            for (i = x0; i < x1; i = i+stepW)
            {
                graphics.moveTo(i, y0);
                graphics.lineTo(i, y1);
            }
            
            for (i = 0; i < 5; ++i)
            {
                var x : int = Math.random()*mwidth;
                var y : int = Math.random() * mheight;
                
                graphics.beginFill(0x000000);
                matrix[x*mwidth+y] = new Stone(Stone.CACTUS);
                graphics.drawRect(x0+x*stepW,y0+y*stepH,stepW, stepH);
                graphics.endFill();
            }
            
            var snake : Snake = new Snake(new Point(10,10));
            graphics.beginFill(0x0000FF);
            graphics.drawRect(x0 + snake.Head.Data.x*stepW, y0 + snake.Head.Data.y*stepH, stepW, stepH);
            graphics.endFill();
            
            
            var word: TextField = new TextField();
            word.x = 0;
            word.y = 0;
          
            addChild(word);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,function(e: KeyboardEvent):void{
                if (e.keyCode == Keyboard.LEFT ||
                    e.keyCode == Keyboard.RIGHT ||
                    e.keyCode == Keyboard.UP ||
                    e.keyCode == Keyboard.DOWN
                )
                {
                    snake.Direction = e.keyCode;
                    var newHead : Point = new Point();
                    switch(e.keyCode)
                    {
                        case Keyboard.LEFT:
                        {
                            newHead.x = snake.Head.Data.x - 1;
                            newHead.y = snake.Head.Data.y;
                            break;
                        }
                        case Keyboard.RIGHT:
                        {
                            newHead.x = snake.Head.Data.x + 1;
                            newHead.y = snake.Head.Data.y;
                            break;
                        }
                        case Keyboard.UP:
                        {
                            newHead.x = snake.Head.Data.x;
                            newHead.y = snake.Head.Data.y - 1;
                            break;
                        }
                        case Keyboard.DOWN:
                        {
                            newHead.x = snake.Head.Data.x;
                            newHead.y = snake.Head.Data.y + 1;
                            break;
                        }

                    }
                    DrawSnake(snake, newHead);
                    
                }
 
                //word.text = e.keyCode == Keyboard.LEFT; 
            });
        }
    }
}

import flash.geom.Point;
class Snake 
{
    public var Direction : int; 
    public var Head : ListElement;
    public var Tail : ListElement;
    
    public function Snake(point : Point) : void
    {
        Head = new ListElement(point, null);
        Tail = Head;
    }

    
    public function DoMove(point : Point) : void
    {
        AddHead (point);
        Tail = Tail.Next;
        Tail.Prev = null;
    }
    
    public function AddHead(point : Point) : void
    {
        Head = new ListElement(point, Head);
    }
}

class Stone
{
    public function Stone (type: int)
    {
        Type = type;
        }
    public static const CACTUS:int = 1;
    public static const TREE:int = 2;
    
    public var Type : int;
}

class Food
{
    public var Type : int;
}


    
class ListElement 
{
    public function ListElement (data : Point, prev : ListElement)
    {
        Data = data;
        Prev = prev;
        if (Prev != null)
            Prev.Next = this;
    }

    public var  Next : ListElement;
    public var  Data : Point;
    public var  Prev : ListElement;
}