/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qCGE
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var brush:BitmapData;
	 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
	 
			var circle:Sprite = new Sprite();
			circle.graphics.beginFill(0x0);
			circle.graphics.drawCircle(7, 7, 7);
			circle.graphics.endFill();
			 
			brush = new BitmapData(14, 14, true, 0x0);
			brush.draw(circle);
	 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
	 
		private function onMouseDown(event:MouseEvent):void
		{	
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	 
		private function onMouseMove(event:MouseEvent):void
		{
			bd.copyPixels(brush, brush.rect, new Point(mouseX - brush.width / 2, mouseY - brush.height / 2));
		}
	 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
