/**
 * Copyright hacker_aft9cz2z ( http://wonderfl.net/user/hacker_aft9cz2z )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qC26
 */

// forked from s26's editer_x_y_point
/*------------------------
    お絵かき用座標取得
絵を描くと一書き分だけ、座標を取得されます。
その座標をコピーして
下記サイトの配列の中につっこめば
光る○で絵を描いてくれます。
http://wonderfl.net/code/cd9d03eeeeec26403846ebc08e1a80efea2b0fc9

------------------------*/

package{
    import flash.display.Sprite;
    import flash.display.MovieClip
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.System;
    import flash.text.TextFormat;
    import flash.text.TextField;
    
    /*------------------------
    お絵かき用座標取得
    ⇒に一筆書きで文字を書くと、
    座標が取得できます。
    ------------------------*/
    
    public class _pen extends Sprite{
        private var dList:Array;
        private var _bg:Sprite;
        private var pen:Sprite;
        private var color:uint = 0x000000;
        private var _xp:Number;
        private var _yp:Number;
        private var nengaTextBox:TextField
        public function _pen() {
            //最初にキャンバスを用意します。ステージの大きさと同じ大きさです。
            _bg = new Sprite();
            addChild(_bg);
            clear_bg();
            pen = new Sprite();
            pen.addEventListener(Event.ENTER_FRAME, onChasePen);
            _bg.addEventListener(MouseEvent.MOUSE_DOWN,_down);
            _bg.addEventListener(MouseEvent.MOUSE_UP,_up);
        }

        private function clear_bg():void{
            dList = new Array();
            _bg.graphics.clear();
            //_bg.graphics.beginFill(0x000000,0);
            _bg.graphics.beginFill(0xEEEEEE,1);
            _bg.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            _bg.graphics.endFill();
        }
        
        private function _down(e:MouseEvent):void{
            var px:int = pen.x;
            var py :int = pen.y;
            _xp = px;_yp = py;
            dList.push("ここの次の部分から、コピーをしてください。⇒");
            dList.push(px);
            dList.push(py);
            _bg.graphics.moveTo(px,py);
            addEventListener( Event.ENTER_FRAME,_draw);
            try{
            nengaTextBox.htmlText = "";
            nengaTextBox.y = -200;
            }catch(e:Error){
                
            }
        }
        
        private function _draw(e:Event):void{
            var px:int = pen.x;
            var py:int = pen.y;
            var x2:int = px;
            var y2:int = py;
            dList.push(x2);
            dList.push(y2);
            _bg.graphics.lineStyle(3,color,1,true);
            _bg.graphics.lineTo(px,py);
        }
        
        private function _up(e:MouseEvent):void{
            removeEventListener( Event.ENTER_FRAME, _draw);
             var nengaText:String = String(dList); 

            var format:TextFormat = new TextFormat();
            format.size = 14;
            format.color = 0xFF0000;

            nengaTextBox = new TextField();
            nengaTextBox.width = 465; 
                       nengaTextBox.height = 400; 
                           nengaTextBox..y = 0;
                    nengaTextBox.multiline = true; 
                    nengaTextBox.wordWrap = true; 
                    nengaTextBox.border   = false;
                    nengaTextBox.defaultTextFormat = format;
                    nengaTextBox.htmlText = nengaText;
            
                 this.addChild(nengaTextBox);
            clear_bg();
        }
        
        public function onChasePen(evt:Event):void{
            pen.x += (mouseX - pen.x)/2;
            pen.y += (mouseY - pen.y)/2;
        }
    }
}
            
            
    