/**
 * Copyright radiohabitat ( http://wonderfl.net/user/radiohabitat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qBxf
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.Shape;
    import flash.geom.Point;
    
    //This is a drawing application tutorial that I was experimenting with 
    //Click and hold the mouse down to create a line 
    //Starting a new line will create a new color based of the random
    
    
    [SWF(width=550, height=400, backgroundColor=0x000000)]
    

    
    
    public class DrawingApplication extends Sprite {
        
        private var _color:uint;
        private var _currentShape:Shape;
        private var _startPosition:Point;
        
      
        
        public function DrawingApplication() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
        }
        
        private function drawLine():void {
            _currentShape.graphics.clear();
            _currentShape.graphics.lineStyle(3, _color);
            _currentShape.graphics.moveTo(_startPosition.x, _startPosition.y);
            _currentShape.graphics.lineTo(stage.mouseX, stage.mouseY);
        }
        
        private function onStageMouseDown(event:MouseEvent):void {
            _color = Math.random()*0xFFFFFF;
            _currentShape = new Shape ();
            addChild(_currentShape);
            _startPosition = new Point(stage.mouseX, stage.mouseY);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
        
        private function onStageMouseUp(event:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
        
        private function onStageMouseMove(event:MouseEvent):void {
            drawLine();
            event.updateAfterEvent();
        }
            // write as3 code here..
            
        
    }
}