/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/qBwR
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.TextField;
    import flash.system.Security;
    import com.actionsnippet.qbox.*;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;
    
    public class Main extends MovieClip
    {
        private const DEPTH:Number = 1;
        private const camera_length:Number = 20;

        private const L:Number = 8;
        private const CUT_MAX:Number = 8;

        private var pairs:Array;
        private var sim:QuickBox2D;
        private var view:BasicView;
        private var mapping:Array = [];
        private var sx:Number;
        private var sy:Number;

        private var loader1:Loader;
        private var loader2:Loader;

        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        private const path:String = "http://assets.wonderfl.net/images/related_images";
        private const filename1:String = path + "/e/ed/ed1c/ed1cadf0fdd830922653b0fa2a5667315bb85ef5";
        private const filename2:String = path + "/3/39/3933/393330f30c725032b7ddee52247d9d46c7041bfa"

        private var material:MaterialObject3D = new BitmapFileMaterial(filename1);
        private var sideMaterial:MaterialObject3D = new BitmapFileMaterial(filename2);

        public function Main() 
        {
            loader1 = new Loader();
            loader1.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader1.load(new URLRequest(filename1), new LoaderContext(true));

            loader2 = new Loader();
            loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader2.load(new URLRequest(filename2), new LoaderContext(true));
        }
        
        public function compHandler(e:Event):void 
        {
            if (loader1.content == null || loader2.content == null) {
                return;
            }

            var bmpData:BitmapData;
            var bmp:Bitmap;
            bmpData = Bitmap(loader1.content).bitmapData.clone();
            bmp = new Bitmap(bmpData);
            material = new BitmapMaterial(bmp.bitmapData);

            bmpData = Bitmap(loader2.content).bitmapData.clone();
            bmp = new Bitmap(bmpData);
            sideMaterial = new BitmapMaterial(bmp.bitmapData);

            view = new BasicView();
            addChild(view);

            sx = stage.width;
            sy = stage.height;
            
            start(null);

            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener( MouseEvent.CLICK , start );
        }

        private function start(e:Event):void
        {
            if (view != null) {
                removeChild(view);
            }
            view = new BasicView();
            addChild(view);
            view.camera.target.y = 10;

            sim = new QuickBox2D(new MovieClip());

            var angle:Number = (Math.random() - 0.5) * 2 * 10/180*Math.PI;
            addBox({ x:0, y:0, width:2*L, height:1, angle:angle, density:0}, material);
            pairs = [LineSliceObject.create(L)];
            var c:Number = 1 + Math.floor(Math.random() * (CUT_MAX - 1));
            for (var i:Number = 0; i < c; i++) {
                cutting();
            }
            recreate();
            sim.start();
        }

        private function t(p:Point):Point
        {
            return new Point(p.y, p.x);
        }
 
        private function cutting():void 
        {
            var p1:Point = new Point(Math.random() * L, 0);
            var p2:Point = new Point(Math.random() * L, L);
            if (Math.random() > 0.5) {
                p1 = t(p1);
                p2 = t(p2);
            }

            var results:Array = [];
            for each (var sliceObj:LineSliceObject in pairs) {
                var r:Array = sliceObj.slice(p1, p2);
                if (r != null) {
                    results.push(r[0]);
                    results.push(r[1]);
                } else {
                    results.push(sliceObj);
                }
            }
            pairs = results;
        }

        private function recreate():void 
        {
            for each (var sliceObj:LineSliceObject in pairs) {
                var ps1:Array = createPointsFromSliceObject(sliceObj);
                ////sim.addPoly({x:-L/2, y:0, points:loop(ps1), wireframe:false });
                addPoly({x:-L/2, y:-20, points:loop(ps1), wireframe:false }, material);
            }
        }

        private function createPointsFromSliceObject(sliceObject:LineSliceObject):Array
        {
                var ps:Array = [];
                for each (var p:Point in sliceObject._pointArray) {
                    ps.push(p.x, p.y);
                }
                return ps;
        }

        private function loop(ps:Array):Array
        {
                return ps.concat([ps[0], ps[1]]);
        }

        public function update(e:Event):void{
            for each(var v:Array in mapping) {
                v[1].x = -v[0].x;
                v[1].y = -v[0].y;
                v[1].rotationZ = v[0].angle * 180 / Math.PI;
            }

            var c:Number = (mouseX / stage.width - 0.5) * (Math.PI / 2);
            var d:Number = (mouseY / sy) * (Math.PI / 2 / 2);
            view.camera.x = Math.sin(c) * Math.cos(d) * camera_length;
            view.camera.z = Math.cos(c) * Math.cos(d) * camera_length;
            view.camera.y = Math.sin(d) * camera_length;

            view.singleRender();
        }

        private function create(obj:QuickObject, obj3d:TriangleMesh3D):void {
            obj3d.rotationX = 90;
            view.scene.addChild(obj3d);
            mapping.push([obj, obj3d]);
            //return obj;
        }

        private function addBox(param:Object, material:MaterialObject3D):void {
            var obj:QuickObject = sim.addBox(param);
            var mlist:MaterialsList = new MaterialsList({all:sideMaterial, top:material, bottom:material});
            var obj3d:TriangleMesh3D = new Cube(mlist, obj.params.width, obj.params.height, DEPTH);
            create(obj, obj3d);
        }

        private function addPoly(param:Object, material:MaterialObject3D):void {
            var ps:Array = [];
            for (var i:Number = 0; i < param.points.length - 2; i += 2) {
                ps.push(new Point(-param.points[i], param.points[i+1]));
            }
            var obj3d:TriangleMesh3D = new Polygon3D(ps, sideMaterial, DEPTH, material,-L,0,0,L);
            //param.points = param.points.concat([0,0]);
            var obj:QuickObject = sim.addPoly(param);
            //return obj;
            create(obj, obj3d);
        }
    }
}

import flash.geom.Point;

class LineSliceObject 
{
    public var _pointArray:Array;

    public static function create( n:Number ):LineSliceObject
    {
        return new LineSliceObject([new Point(0,0), new Point(0,n), new Point(n,n), new Point(n,0)]);
    }

    public function LineSliceObject( _pointArray:Array ) 
    {
        this._pointArray = _pointArray;
    }

    public function slice( _point1:Point , _point2:Point ):Array
    {
        var _pt1:Point = _point1;//globalToLocal( _point1 );
        var _pt2:Point = _point2;//globalToLocal( _point2 );
        var _newPointArray:Array = [ new Array() , new Array() ];
        var _numCloss:int = 0;
        
        for ( var i:int = 0; i < _pointArray.length ; i ++ ) 
        {
            var _pt3:Point = _pointArray[ i ];
            var _pt4:Point = ( _pointArray[ i + 1 ] ) ? _pointArray[ i + 1 ] : _pointArray[ 0 ];
            var _clossPt:Point = crossPoint( _pt1 , _pt2 , _pt3 , _pt4 );
            
            _newPointArray[ 0 ].push( _pt3 );
            if ( _clossPt )
            {
                _newPointArray[ 0 ].push( _clossPt );
                _newPointArray[ 1 ].push( _clossPt );
                _newPointArray.reverse();
                _numCloss ++;
            }
        }
        if ( _numCloss == 2 ) {
            var _newObj1:LineSliceObject = new LineSliceObject( _newPointArray[ 0 ] );
            var _newObj2:LineSliceObject = new LineSliceObject( _newPointArray[ 1 ] );
            return [_newObj1, _newObj2];
        } else {
            return null;
        }
    }
    
    private function crossPoint( _pt1:Point , _pt2:Point , _pt3:Point , _pt4:Point ):Point
    {    
        var _vector1:Point = _pt2.subtract( _pt1 );
        var _vector2:Point = _pt4.subtract( _pt3 );
        
        if ( cross( _vector1, _vector2 ) == 0.0) return null;
        
        var _s:Number = cross( _vector2 , _pt3.subtract( _pt1) ) / cross( _vector2 , _vector1 );
        var _t:Number = cross( _vector1, _pt1.subtract( _pt3 ) ) / cross( _vector1, _vector2 );

        if ( isCross( _s ) && isCross( _t ) )
        {
            _vector1.x *= _s;
            _vector1.y *= _s;
            return _pt1.add( _vector1 );
        }
        else return null;
    }
        
    private function cross( _vector1:Point , _vector2:Point ):Number
    {
        return ( _vector1.x * _vector2.y - _vector1.y * _vector2.x );
    }
    
    public static function isCross( _n:Number ):Boolean
    {
        return ( ( 0 <= _n ) && ( _n <= 1) );
    }
}

import flash.geom.*;
import org.papervision3d.Papervision3D;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.core.math.*;
import org.papervision3d.core.proto.*;    
 
class Polygon3D extends TriangleMesh3D
{
    private var minx:Number;
    private var miny:Number;
    private var maxx:Number;
    private var maxy:Number;


    public function Polygon3D( points:Array, sideMaterial:MaterialObject3D, height:Number, surfaceMaterial:MaterialObject3D,
                               minx:Number, miny:Number, maxx:Number, maxy:Number)
    {
        super( sideMaterial, new Array(), new Array(), null );
 
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
 
        var n:int = points.length;
        var i:Number;
        var vs0:Array = [];
        var vs1:Array = [];

        for each (var p:Point in points) {
            var v:Vertex3D;
            v = new Vertex3D(p.x, height * 0.5, p.y);
            this.geometry.vertices.push(v);
            vs0.push(v);
            v = new Vertex3D(p.x, -height * 0.5, p.y);
            this.geometry.vertices.push(v);
            vs1.push(v);
        }

        var uv00:NumberUV = new NumberUV(0, 0);
        var uv01:NumberUV = new NumberUV(0, 1);
        var uv10:NumberUV = new NumberUV(1, 0);
        var uv11:NumberUV = new NumberUV(1, 1);
        for (i = 0; i < n; i++) {
            var i2:Number = (i + 1) % n;
            this.geometry.faces.push( new Triangle3D(this, [vs0[i], vs1[i2], vs0[i2]], sideMaterial, [uv00, uv11, uv10]) );
            this.geometry.faces.push( new Triangle3D(this, [vs0[i],  vs1[i], vs1[i2]], sideMaterial, [uv00, uv01, uv11]) );
        }

        var ps:Array;
        for (i = 0; i < (n - 2)/2; i++) {
            ps = [vs0[i], vs0[n-2-i], vs0[n-1-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, to_uvs(ps)));            
            ps = [vs1[i], vs1[n-1-i], vs1[n-2-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, rev(to_uvs(ps))));
        }
        for (i = 0; i < (n - 3)/2; i++) {
            ps = [vs0[i], vs0[i+1], vs0[n-2-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, to_uvs(ps)));            
            ps = [vs1[i], vs1[n-2-i], vs1[i+1]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, rev(to_uvs(ps))));
        }
        
        this.geometry.ready = true;
        if(Papervision3D.useRIGHTHANDED)
            this.geometry.flipFaces();
    }
    
    private function to_uvs(ps:Array):Array
    {
        var uvs:Array = [];
        for each (var p:Vertex3D in ps) {
            uvs.push(new NumberUV((p.x - minx)/(maxx - minx), (p.z - miny)/(maxy - miny)));
        }
        return uvs;
    }
    private function rev(uvs:Array):Array
    {
        var ruvs:Array = [];
        for each (var uv:NumberUV in uvs) {
            ruvs.push(new NumberUV(uv.u, 1 - uv.v));
        }
        return ruvs;
    }
}