/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qBZ0
 */

package
{
	// 参考 http://www16.ocn.ne.jp/~akiko-y/heart/index_heart.html
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Hearts extends Sprite
	{
		private const WIDHT:Number = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		
		private var isDown:Boolean = false;
		public var hearts:Array = [];
		
		
		public function Hearts()
		{
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, WIDHT, HEIGHT);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			isDown = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			isDown = false;
		}
		
		private function loop(e:Event):void
		{
			if(isDown)
			{
				var heart:Heart = new Heart();
				heart.x = mouseX;
				heart.y = mouseY;
				hearts.push(heart);
				addChild(heart);
			}
			
			move();
		}
		
		private function move():void
		{
			var i:int = hearts.length;
			while(i--)
			{
				var heart:Heart = hearts[i];
				heart.sc += heart.speed;
				heart.scaleX = Math.cos(heart.sc);
				if(heart.sc > 20)
				{
					removeChild(heart);
					hearts.splice(i, 1);
				}
			}
		}
	}
}
	import flash.display.Shape;
	

class Heart extends Shape
{
	private var sx:Number;
	private var sy:Number;
	private var b:Number;
	private var i:int;
	private var imax:int;
	private var j:int;
	private var xmax:Number;
	private var dx:Number;
	private var xx:Array;
	private var yy:Array;
	private var times:int = Math.random()*45+5;
	public var sc:Number = 0;
	public var speed:Number = Math.random()*0.25+0.25;
	
	
	public function Heart()
	{
		b = 0.8;
		
		xmax = 1;
		dx = xmax/1000;
		
		i = 0;
		
		xx = [];
		yy = [];
		
		for (sx=0;sx<=xmax;sx=sx+dx)
		{
			i++;
			
			xx[i] = sx;
			sy = Math.sqrt(1-sx*sx)+b*Math.sqrt(sx);
			yy[i] = sy;
		}
		
		for (sx=xmax;sx>=0;sx=sx-dx)
		{
			i++;
			
			xx[i] = sx;
			sy = -Math.sqrt(1-sx*sx)+b*Math.sqrt(sx);
			yy[i] = sy;
		}
		
		for (sx=0;sx>=-xmax;sx=sx-dx)
		{
			i++;
			
			xx[i] = sx;
			sy = -Math.sqrt(1-sx*sx)+b*Math.sqrt(-sx);
			yy[i] = sy;
		}
		
		for (sx=-xmax;sx<=0;sx=sx+dx)
		{
			i++;
			
			xx[i] = sx;
			sy = Math.sqrt(1-sx*sx)+b*Math.sqrt(-sx);
			yy[i] = sy;
		}
		
		imax=i;
		j=0;
		
		// ハート書く
		graphics.lineStyle(3, 0xFF0000);
		for (i=1;i<imax;i++)
		{
			if(i == 1)
			{
				graphics.moveTo(xx[i]*times, yy[i]*times);
			}
			else
			{
				graphics.lineTo(xx[i]*times, yy[i]*times);
			}
		}
		
		this.scaleY = -1;
	}
}