/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qBDd
 */

// forked from s8t1h12akj's forked from: アレの画像変形のアレぽい何か forked from: ImageSelectCursor
// forked from naoto5959's アレの画像変形のアレぽい何か forked from: ImageSelectCursor
package {
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.net.URLRequest;
	import flash.display.DisplayObject;
	import flash.system.LoaderContext;
	import jp.progression.commands.display.AddChild;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.net.LoadBitmapData;

	[SWF(width = "465", height = "465", backgroundColor = "0xCCCCCC", frameRate = "30")]
	public class Main extends Sprite {
		/**
		 * あのひと
		 */
		public static const KARE_URL:String 
			= "http://wonderfl.net/static/tmp/related_images/59da706ee3457ca8929bbaa3c6116c5de8000286m";
		/**
		 * あいつ
		 */
		public static const AITSU_URL:String
			= "http://assets.wonderfl.net/images/related_images/2/2f/2f1d/2f1dc779a23daed937d904be5017822f691864ae";
			
		/**
		 * 変形ツール付きDisplayObject
		 */
		public var resizableObject1:ResizableObject;
		public var resizableObject2:ResizableObject;
		public function Main() {
			resizableObject1 = new ResizableObject();
			resizableObject1.x = stage.stageWidth / 2;
			resizableObject1.y = stage.stageHeight / 2;
			
			resizableObject2 = new ResizableObject();
			resizableObject2.x = stage.stageWidth / 3;
			resizableObject2.y = stage.stageHeight / 3;
			var cmd:SerialList = new SerialList();
			cmd.addCommand(
				new LoadBitmapData(new URLRequest(KARE_URL), {context:new LoaderContext(true)}),
				function():void {
					var content:DisplayObject = new Bitmap(this.latestData) as DisplayObject;
					content.scaleX = content.scaleY = 0.5;
					resizableObject1.addContent(content);
				},
				new AddChild(this, resizableObject1),
				new Func(resizableObject1.activate),
				new LoadBitmapData(new URLRequest(AITSU_URL), {context:new LoaderContext(true)}),
				function():void {
					var content:DisplayObject = new Bitmap(this.latestData) as DisplayObject;
					content.scaleX = content.scaleY = 0.5;
					resizableObject2.addContent(content);
				},
				new AddChild(this, resizableObject2),
				new Func(resizableObject2.activate)
			);
			cmd.execute();
		}
	}
}
import flash.events.Event;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.ui.Mouse;

class ResizableObject extends Sprite {
	public var minimumSize:Number = 30;
	public var toolSize:Number = 15;
	public var toolFgColor:uint = 0xEEEEEE;
	public var toolBgColor:uint = 0x111111;
	public var toolLineColor:uint = 0xFF111111;
	
	/**
	 * contentを保持するコンテナー
	 */
	private var _container:Sprite;
	
	private var _line:Shape;
	private var _tool:Sprite;
	private var _toolRotation:ToolRotation;
	private var _toolResize:ToolResize;
	private var _toolResizeH:ToolResizeH;
	private var _toolResizeV:ToolResizeV;
	private var _center:Shape;
	private var _selectedTool:Sprite;
	
	private var _cursor:Cursor;
	
	public function ResizableObject() {
		_container = new Sprite();
		addChild(_container);
		
		_tool = new Sprite();
		addChild(_tool);
		
		_line = new Shape();
		_tool.addChild(_line);
		_toolRotation = new ToolRotation();
		_tool.addChild(_toolRotation);
		_toolResize = new ToolResize();
		_tool.addChild(_toolResize);
		_toolResizeH = new ToolResizeH();
		_tool.addChild(_toolResizeH);
		_toolResizeV = new ToolResizeV();
		_tool.addChild(_toolResizeV);
		_center = new Shape();
		_tool.addChild(_center);
		
		_cursor = new Cursor();
		_cursor.visible = false;
		addChild(_cursor);
	}
	
	public function addContent(displayObject: DisplayObject):DisplayObject {
		if (displayObject && _container && _container.contains(displayObject)) {
			_container.removeChild(displayObject);
		}
		displayObject.addEventListener(Event.ADDED, function(e:Event):void {
			displayObject.removeEventListener(Event.ADDED, arguments.callee);
			var mt:Matrix = displayObject.transform.matrix;
			var rect:Rectangle = displayObject.getBounds(displayObject.parent);
			// (0, 0)に移動
			mt.translate(-(rect.left + rect.width / 2), -(rect.top + rect.height / 2));
			displayObject.transform.matrix = mt;
		});
		
		_container.addChild(displayObject);
		return displayObject;
	}
	
	public function activate():void {
		_container.buttonMode = true;
		stage.addEventListener(MouseEvent.CLICK, _onClickStage);
		_container.addEventListener(MouseEvent.MOUSE_DOWN, _onDownContainer);
		_container.addEventListener(MouseEvent.MOUSE_UP, _onUpContainer);
		
		_toolRotation.addEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolRotation.addEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolRotation.addEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResize.addEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResize.addEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResize.addEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResizeH.addEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResizeH.addEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResizeH.addEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResizeV.addEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResizeV.addEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResizeV.addEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		stage.addEventListener(MouseEvent.MOUSE_UP, _onUpStage);

	}
	
	public function deactivate():void {
		_container.buttonMode = false;
		stage.removeEventListener(MouseEvent.CLICK, _onClickStage);
		_container.removeEventListener(MouseEvent.MOUSE_DOWN, _onDownContainer);
		_container.removeEventListener(MouseEvent.MOUSE_UP, _onUpContainer);
		
		_toolRotation.removeEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolRotation.removeEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolRotation.removeEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResize.removeEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResize.removeEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResize.removeEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResizeH.removeEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResizeH.removeEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResizeH.removeEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		
		_toolResizeV.removeEventListener(MouseEvent.MOUSE_OVER, _onOverTool);
		_toolResizeV.removeEventListener(MouseEvent.MOUSE_OUT, _onOutTool);
		_toolResizeV.removeEventListener(MouseEvent.MOUSE_DOWN, _onDownTool);
		stage.removeEventListener(MouseEvent.MOUSE_UP, _onUpStage);

	}
	
	private function _onClickStage(e:MouseEvent):void {
		if (e.target == _container) {
			_drawTool();
		} else {
			_tool.visible = false;
		}
	}
	
	private function _onDownContainer(e:MouseEvent):void {
		_drawTool();
		_container.startDrag();
		_container.alpha = 0.5;
		stage.addEventListener(MouseEvent.MOUSE_MOVE, _onDragContainer);
	}
	
	private function _onDragContainer(e:MouseEvent):void {
		_tool.x = _container.x;
		_tool.y = _container.y;
	}
	
	private function _onUpContainer(e:MouseEvent):void {
		_container.stopDrag();
		_container.alpha = 1.0;
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, _onDragContainer);
	}
	
	private function _onOverTool(e:MouseEvent):void {
		Mouse.hide();
		_cursor.visible = true;
		addEventListener(Event.ENTER_FRAME, _onEnterFrameOnTool);
	}
	
	private function _onEnterFrameOnTool(e:Event):void {
		_cursor.x = mouseX;
		_cursor.y = mouseY;
		var P1:Point = new Point(_tool.x, _tool.y);
		var P2:Point = new Point(mouseX,mouseY);
		var vector:Point = P2.subtract(P1);
		var angle:Number = Math.atan2(vector.y,vector.x) * 180/Math.PI
		_cursor.rotation = Math.round((angle + 90)/45) * 45;
	}
		
	private function _onOutTool(e:MouseEvent):void {
		Mouse.show();
		_cursor.visible = false;
		removeEventListener(Event.ENTER_FRAME, _onEnterFrameOnTool);
	}
	
	private function _onDownTool(e:MouseEvent):void {
		_selectedTool = e.target as Sprite;
		stage.addEventListener(MouseEvent.MOUSE_MOVE, _onMoveOnStage);
	}
	
	private function _onMoveOnStage(e:MouseEvent):void {

		var distanceX:Number = Math.abs(_container.x - mouseX);
		var distanceY:Number = Math.abs(_container.y - mouseY);
		var distance:Number = Math.sqrt(distanceX*distanceX + distanceY*distanceY);

		var oldRotation:Number = _container.rotation;
		_container.rotation = _tool.rotation = 0;
		
		var diffAngle:Number = Math.atan2(_toolRotation.y, _toolRotation.x) / Math.PI * 180;
		if (_selectedTool is ToolResize) {
			var ratio:Number;
			if (distanceX > distanceY) {
				 // 横の方が距離が長い
				 ratio = distanceX * 2 / _container.width;
			} else {
				 ratio = distanceY * 2 / _container.height;
			}
			_container.width *= ratio;
			_container.height *= ratio;
			
			_container.rotation = _tool.rotation = oldRotation;
			_drawTool();
		} else if (_selectedTool is ToolResizeH) {
			_container.width = (distance * 2 > minimumSize)?distance * 2:minimumSize;
			_container.rotation = _tool.rotation = oldRotation;
			_drawTool();
		} else if (_selectedTool is ToolResizeV) {
			_container.height = (distance * 2 > minimumSize)?distance * 2:minimumSize;
			_container.rotation = _tool.rotation = oldRotation;
			_drawTool();
		} else if (_selectedTool is ToolRotation) {
			_container.rotation = _tool.rotation = oldRotation;
			_container.rotation = (Math.atan2(mouseY - _container.y, mouseX - _container.x)  / Math.PI )* 180 - diffAngle;
			_tool.rotation = _container.rotation;
		}

	}
	
	private function _onUpStage(e:MouseEvent):void {
		_selectedTool = null;
		Mouse.show();
		_cursor.visible = false;
		_onUpContainer(null);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, _onMoveOnStage);
	}
	
	/**
	 * ツールを描写する
	 */
	private function _drawTool():void {
		_tool.visible = true;
		var obj:DisplayObject = _container;
		
		// 一旦回転なしにしてから描写する
		var oldRotation:Number = _container.rotation;
	   _container.rotation = 0;
	   _tool.rotation = 0;

		//点線横
		var bmdx:BitmapData = new BitmapData(4,1,true);
		bmdx.setPixel32(0, 0, toolLineColor);
		bmdx.setPixel32(1, 0, toolLineColor);
		bmdx.setPixel32(2, 0, 0);
		bmdx.setPixel32(3, 0, 0);
		
		//点線縦
		var bmdy:BitmapData = new BitmapData(1,4);
		bmdy.setPixel32(0, 0, toolLineColor);
		bmdy.setPixel32(0, 1, toolLineColor);
		bmdy.setPixel32(0, 2, 0);
		bmdy.setPixel32(0, 3, 0);
		
		//点線カーソル
		_line.graphics.clear();
		_line.graphics.beginBitmapFill(bmdx);
		_line.graphics.drawRect(-obj.width/2,-obj.height/2,obj.width,1);
		_line.graphics.drawRect(-obj.width/2,obj.height/2,obj.width,1);
		_line.graphics.endFill();
		_line.graphics.beginBitmapFill(bmdy);
		_line.graphics.drawRect(-obj.width/2,-obj.height/2,1,obj.height);
		_line.graphics.drawRect(obj.width/2,-obj.height/2,1,obj.height);
		_line.graphics.endFill();
		
		var size:uint = 12;
		
		// 回転ツール
		_toolRotation.graphics.clear();
		_toolRotation.graphics.lineStyle(2, toolFgColor, 1, true, LineScaleMode.NONE,CapsStyle.SQUARE);
		_toolRotation.graphics.beginFill(toolBgColor);
		_toolRotation.graphics.drawRect(0, 0, toolSize, toolSize);
		_toolRotation.x = obj.width/2 - toolSize/2;
		_toolRotation.y = -obj.height/2 - toolSize/2;
		
		// 水平変形ツール
		_toolResizeH.graphics.clear();
		_toolResizeH.graphics.lineStyle(2, toolFgColor, 1, true, LineScaleMode.NONE,CapsStyle.SQUARE);
		_toolResizeH.graphics.beginFill(toolBgColor);
		_toolResizeH.graphics.drawRect(0, 0, toolSize, toolSize);
		_toolResizeH.x = obj.width/2 - toolSize/2;
		_toolResizeH.y = -toolSize/2;
		
		// 変形ツール
		_toolResize.graphics.clear();
		_toolResize.graphics.lineStyle(2, toolFgColor, 1, true, LineScaleMode.NONE,CapsStyle.SQUARE);
		_toolResize.graphics.beginFill(toolBgColor);
		_toolResize.graphics.drawRect(0, 0, toolSize, toolSize);
		_toolResize.x = obj.width/2 - toolSize/2;
		_toolResize.y = obj.height/2 - toolSize/2;
		
		// 垂直変形ツール
		_toolResizeV.graphics.clear();
		_toolResizeV.graphics.lineStyle(2, toolFgColor, 1, true, LineScaleMode.NONE,CapsStyle.SQUARE);
		_toolResizeV.graphics.beginFill(toolBgColor);
		_toolResizeV.graphics.drawRect(0, 0, toolSize, toolSize);
		_toolResizeV.x = -toolSize/2;
		_toolResizeV.y = obj.height/2 - toolSize/2;
		
		//ポインタ中心
		_center.graphics.clear();
		_center.graphics.lineStyle(2, toolFgColor, 1, true, LineScaleMode.NONE,CapsStyle.SQUARE);
		_center.graphics.beginFill(toolBgColor);
		_center.graphics.drawCircle(0, 0, toolSize/2);
		_center.graphics.endFill();
		
		_container.rotation = _tool.rotation = oldRotation;
	}
}

/**
 * Nyarineko's ImageSelectCursor
 */
import flash.display.*;
class Cursor extends Shape {
    public function Cursor():void {
        drawCursor();
    }
    private function drawCursor():void {
        graphics.lineStyle(1,0xFFFFFF,1,true,LineScaleMode.NONE,CapsStyle.SQUARE);
        graphics.beginFill(0x000000);
        graphics.moveTo(0,-8);
        graphics.lineTo(4,-4);
        graphics.lineTo(1,-4);
        graphics.lineTo(1,4);
        graphics.lineTo(4,4);
        graphics.lineTo(0,8);
        graphics.lineTo(-4,4);
        graphics.lineTo(-1,4);
        graphics.lineTo(-1,-4);
        graphics.lineTo(-4,-4);
        graphics.lineTo(0,-8);
        graphics.endFill();
    }
}

class ToolRotation extends Sprite {
}

class ToolResize extends Sprite {
}

class ToolResizeH extends Sprite {
}

class ToolResizeV extends Sprite {
}